package com.marketingconfort.adanev.vsn.document.mappers;

import com.marketingconfort.adanev.vsn.document.config.EnvConfigLoader;
import com.marketingconfort.adanev.vsn.document.dtos.DocumentDTO;
import com.marketingconfort.adanev.vsn.document.models.Document;
import com.marketingconfort.adanev.vsn.document.models.Folder;
import com.marketingconfort.adanev.vsn.document.services.Implementations.DocumentStorageService;
import com.marketingconfort.starter.core.exceptions.FunctionalException;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

@Component
@AllArgsConstructor
public class DocumentMapper {
    private final DocumentStorageService documentStorageService;
    private final String bucketName = EnvConfigLoader.getEnvironmentConfig().getAws().getBucketName();

    // Map document to DTO
    public DocumentDTO toDto(Document document) {
        if (document == null) return null;

        DocumentDTO dto = new DocumentDTO();
        dto.setId(document.getId());
        dto.setName(document.getName());
        dto.setPath(document.getPath());
        dto.setSize(document.getSize());
        dto.setContentType(document.getContentType());
        dto.setS3Key(document.getS3Key());
        dto.setOwnerId(document.getOwnerId());
        dto.setDocumentType(document.getDocumentType());
        dto.setFavorite(document.isFavorite());
        dto.setCreatedAt(document.getCreatedAt());

        try {
            String presignedUrl = documentStorageService.getFileSharableLink(bucketName, document.getS3Key());
            dto.setDownloadUrl(presignedUrl);
        } catch (FunctionalException e) {
            dto.setDownloadUrl(null); // fallback
        }
        return dto;
    }

    // Map DTO to document
    public static Document toEntity(DocumentDTO dto, Folder folder) {
        if (dto == null) return null;

        Document document = new Document();
        document.setId(dto.getId());
        document.setName(dto.getName());
        document.setPath(dto.getPath());
        document.setSize(dto.getSize());
        document.setContentType(dto.getContentType());
        document.setS3Key(dto.getS3Key());
        document.setOwnerId(dto.getOwnerId());
        document.setDocumentType(dto.getDocumentType());
        document.setFavorite(dto.isFavorite());
        document.setFolder(folder); // assumed preloaded

        return document;
    }
}
