package com.marketingconfort.adanev.vsn.document.repositories;

import com.marketingconfort.adanev.vsn.document.dtos.FolderDTO;
import com.marketingconfort.adanev.vsn.document.models.Folder;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.data.domain.Pageable;
import java.util.List;
import java.util.Optional;

@Repository
public interface FolderRepository extends JpaRepository<Folder, Long>, JpaSpecificationExecutor<Folder> {

    boolean existsByNameAndOwnerUuidAndParent(String name, String ownerUuid, Folder parent);
    List<Folder> findByOwnerUuidAndParentIsNull(String ownerUuid);
    List<Folder> findByParentIdAndOwnerUuid(Long parentId, String ownerUuid);
    @Query("SELECT DISTINCT f FROM Folder f " +
            "LEFT JOIN f.documents d " +
            "WHERE LOWER(f.name) LIKE %:keyword% " +
            "   OR LOWER(d.name) LIKE %:keyword%")
    Page<Folder> searchFoldersByKeyword(@Param("keyword") String keyword, Pageable pageable);

    Optional<Folder> findByNameAndOwnerUuid(String name, String ownerUuid);
    List<Folder> findByOwnerUuid(String ownerUuid);
    List<Folder> findByOwnerUuidAndFavoriteTrue(String ownerUuid);

    @Query("SELECT f FROM Folder f LEFT JOIN f.documents d " +
            "WHERE f.ownerUuid = :ownerUuid AND " +
            "(LOWER(f.name) LIKE %:keyword% OR LOWER(d.name) LIKE %:keyword%)")
    Page<Folder> searchFoldersByKeywordAndOwnerUuid(@Param("keyword") String keyword,
                                                    @Param("ownerUuid") String ownerUuid,
                                                    Pageable pageable);

    Optional<Folder> findByOwnerUuidAndName(String targetUserUuid, String sharedWithMe);

    Optional<Folder> findByNameAndOwnerId(String sharedWithMe, Long userId);

    List<Folder> findByOwnerId(Long ownerId);

    Optional<Folder> findByOwnerIdAndName(Long targetUserId, String sharedWithMe);
}
