package com.marketingconfort.adanev.vsn.document.services;

import com.marketingconfort.adanev.vsn.document.dtos.DocumentDTO;
import com.marketingconfort.adanev.vsn.document.dtos.DocumentStatisticsDTO;
import com.marketingconfort.adanev.vsn.document.dtos.requests.AddDocumentRequest;
import com.marketingconfort.adanev.vsn.document.dtos.response.DocumentUploadResponseDTO;
import com.marketingconfort.adanev.vsn.document.enums.ContentType;
import com.marketingconfort.adanev.vsn.document.enums.DocumentType;
import com.marketingconfort.starter.core.exceptions.FunctionalException;
import com.marketingconfort.starter.core.exceptions.S3FunctionalException;
import org.springframework.core.io.InputStreamResource;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

public interface DocumentService {

    @Transactional
    String importDocument(MultipartFile file, AddDocumentRequest request) throws FunctionalException, IOException, S3FunctionalException;
    String importDocumentToRoot(MultipartFile file,AddDocumentRequest request) throws FunctionalException, IOException, S3FunctionalException;
    List<DocumentDTO> getDocumentsByOwnerId(Long ownerId) throws FunctionalException;
    DocumentDTO getDocumentByIdAndOwner(Long documentId, Long ownerId) throws FunctionalException;
    List<DocumentDTO> getRootDocumentsByOwnerId(Long ownerId);
    List<DocumentStatisticsDTO> getDocumentStatistics(Long ownerId);
    String getDocumentDownloadLink(Long documentId, Long ownerId) throws FunctionalException;
    ResponseEntity<InputStreamResource> downloadDocument(Long documentId, Long ownerId) throws FunctionalException;
    List<DocumentDTO> searchAndSortDocuments(Long ownerId, String keyword, String sortBy, boolean asc);
    Page<DocumentDTO> advancedSearchDocuments(Long ownerId,
            String keyword,
            ContentType contentType,
            DocumentType documentType,
            String sortBy,
            boolean asc,
            int page,
            int size);
    void deleteDocument(Long documentId, Long ownerId) throws FunctionalException;
    void bulkDeleteDocuments(List<Long> documentIds, Long ownerId) throws FunctionalException;
    void shareDocument(Long documentId, Long targetUserId) throws FunctionalException, S3FunctionalException;
    void bulkShareDocuments(List<Long> documentIds, Long targetUserId) throws FunctionalException, S3FunctionalException;
    void markAsFavorite(Long documentId, Long ownerId) throws FunctionalException;
    void unmarkAsFavorite(Long documentId, Long ownerId) throws FunctionalException;
    List<DocumentDTO> getFavoriteDocuments(Long ownerId);
    void moveDocument(Long documentId, Long targetFolderId, Long ownerId) throws FunctionalException, S3FunctionalException;
    void bulkMoveDocuments(List<Long> documentIds, Long targetFolderId, Long ownerId) throws FunctionalException, S3FunctionalException;
    public void renameDocument(Long documentId, String newName, Long ownerId) throws FunctionalException, S3FunctionalException;
}
