package com.marketingconfort.adanev.vsn.document.services;

import com.marketingconfort.adanev.vsn.document.dtos.DocumentDTO;
import com.marketingconfort.adanev.vsn.document.dtos.FolderDTO;
import com.marketingconfort.adanev.vsn.document.dtos.requests.NewFolderRequest;
import com.marketingconfort.adanev.vsn.document.dtos.requests.ShareFolderRequest;
import com.marketingconfort.adanev.vsn.document.dtos.response.FolderDetailsResponse;
import com.marketingconfort.adanev.vsn.document.dtos.response.FolderSizeResponseDTO;
import com.marketingconfort.starter.core.exceptions.FunctionalException;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;

import java.io.IOException;
import java.util.List;

public interface FolderService {
    FolderDTO createFolder(NewFolderRequest request) throws FunctionalException;
    FolderDTO renameFolder(Long id, String newName, String ownerUuid) throws FunctionalException;
    void deleteFolderById(Long folderId, String ownerUuid) throws FunctionalException;
    FolderDTO moveFolder(Long folderId, Long newParentId, String ownerUuid) throws FunctionalException;
    List<FolderDTO> listRootFolders(String ownerUuid);
    List<FolderDTO> listSubFolders(Long parentId, String ownerUuid);
    List<DocumentDTO> listDocumentsInFolder(Long folderId, String ownerUuid);
    List<FolderDTO> searchFolders(String keyword, String ownerUuid);
    FolderDetailsResponse getFolderDetails(Long folderId) throws FunctionalException;
    Page<FolderDTO> advancedSearchFolders(String keyword, String ownerUuid, int page, int size, String sortBy, String sortDirection) throws FunctionalException;
    void shareFolderWithUsers(ShareFolderRequest request) throws FunctionalException;
    void unshareFolderWithUser(Long folderId, String userUuid) throws FunctionalException;
    byte[] zipFolderAndReturn(Long folderId) throws FunctionalException;
    ResponseEntity<byte[]> downloadZippedFolder(Long folderId) throws FunctionalException;
    FolderSizeResponseDTO calculateFolderSize(Long folderId) throws FunctionalException;
    void markFolderAsFavorite(Long folderId, String userUuid) throws FunctionalException;
    void unmarkFolderAsFavorite(Long folderId, String userUuid) throws FunctionalException;
    List<FolderDTO> getFavoriteFolders(String userUuid);
    void bulkDelete(List<Long> folderIds, String ownerUuid) throws FunctionalException;
    void bulkShare(List<Long> folderIds, List<Long> userIds) throws FunctionalException;
    void bulkMove(List<Long> folderIds, Long newParentId, String ownerUuid) throws FunctionalException;
}
