package com.marketingconfort.adanev.vsn.document.services.Implementations;


import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import org.springframework.stereotype.Component;

import java.text.ParseException;

@Component
public class AuthorizationService {


    public boolean isTokenSubjectOwner(String bearerToken, String ownerUuid) {
        try {
            // Extraire le JWT brut sans le préfixe "Bearer "
            String token = bearerToken.replaceFirst("^Bearer ", "").trim();

            // Parser le JWT pour obtenir les claims
            SignedJWT signedJWT = SignedJWT.parse(token);
            JWTClaimsSet claims = signedJWT.getJWTClaimsSet();

            String subject = claims.getSubject(); // sub

            return subject != null && subject.equals(ownerUuid);

        } catch (ParseException e) {
            return false;
        }
    }
}

