package com.marketingconfort.adanev.vsn.document.services;

import com.marketingconfort.adanev.vsn.document.dtos.StorageQuotaInfoDTO;
import com.marketingconfort.starter.core.exceptions.FunctionalException;

public interface StorageQuotaService {


     // storage quota for an owner
    StorageQuotaInfoDTO getStorageQuotaInfo(Long ownerId) throws FunctionalException;

    // Check if owner has enough storage space
    boolean hasAvailableStorage(Long ownerId, Long additionalSizeBytes) throws FunctionalException;

    // Check if storage quota is exceeded
    boolean isStorageQuotaExceeded(Long ownerId) throws FunctionalException;

    //storage usage percentage
    double getStorageUsagePercentage(Long ownerId) throws FunctionalException;

    //total used storage by owner
    Long getTotalUsedStorage(Long ownerId) throws FunctionalException;

    // available storage for owner
    Long getAvailableStorage(Long ownerId) throws FunctionalException;
}
