package com.marketingconfort.adanev.vsn.document.utils;

import com.marketingconfort.adanev.vsn.document.dtos.DocumentDTO;
import com.marketingconfort.adanev.vsn.document.dtos.FolderDTO;

public class FolderSizeCalculator {

    public static long calculateFolderSize(FolderDTO folder) {
        if (folder == null) {
            return 0L;
        }

        long totalSize = 0L;

        // Sum up sizes of all documents in this folder
        if (folder.getDocuments() != null) {
            for (DocumentDTO document : folder.getDocuments()) {
                if (document != null && document.getSize() != null) {
                    totalSize += document.getSize();
                }
            }
        }

        // Recursively calculate sizes of all subfolders
        if (folder.getSubFolders() != null) {
            for (FolderDTO subFolder : folder.getSubFolders()) {
                totalSize += calculateFolderSize(subFolder);
            }
        }

        return totalSize;
    }

    //size of a folder and returns it in a human-readable format("1.5 MB", "2.3 GB")
    public static String calculateFolderSizeFormatted(FolderDTO folder) {
        long sizeInBytes = calculateFolderSize(folder);
        return formatBytes(sizeInBytes);
    }

    public static String formatBytes(long bytes) {
        if (bytes < 0) {
            return "0 B";
        }

        String[] units = {"B", "KB", "MB", "GB", "TB", "PB"};
        int unitIndex = 0;
        double size = bytes;

        while (size >= 1024 && unitIndex < units.length - 1) {
            size /= 1024;
            unitIndex++;
        }

        if (unitIndex == 0) {
            return String.format("%.0f %s", size, units[unitIndex]);
        } else {
            return String.format("%.1f %s", size, units[unitIndex]);
        }
    }

    public static int countFilesInFolder(FolderDTO folder) {
        if (folder == null) {
            return 0;
        }

        int fileCount = 0;

        // Count documents in this folder
        if (folder.getDocuments() != null) {
            fileCount += folder.getDocuments().size();
        }

        // Recursively count files in subfolders
        if (folder.getSubFolders() != null) {
            for (FolderDTO subFolder : folder.getSubFolders()) {
                fileCount += countFilesInFolder(subFolder);
            }
        }

        return fileCount;
    }

    public static int countSubfoldersInFolder(FolderDTO folder) {
        if (folder == null || folder.getSubFolders() == null) {
            return 0;
        }

        int subfolderCount = folder.getSubFolders().size();

        // Recursively count subfolders in each subfolder
        for (FolderDTO subFolder : folder.getSubFolders()) {
            subfolderCount += countSubfoldersInFolder(subFolder);
        }

        return subfolderCount;
    }
}
