package com.marketingconfort.adanev.vsn.document.utils;


import com.marketingconfort.adanev.vsn.document.constants.StorageQuotaConstants;

public class StorageQuotaUtils {

    public static boolean isWarningLevel(double usagePercentage) {
        return usagePercentage >= StorageQuotaConstants.WARNING_THRESHOLD && usagePercentage < StorageQuotaConstants.CRITICAL_THRESHOLD;
    }

    public static boolean isCriticalLevel(double usagePercentage) {
        return usagePercentage >= StorageQuotaConstants.CRITICAL_THRESHOLD && usagePercentage < 100.0;
    }

    public static boolean isExceeded(double usagePercentage) {
        return usagePercentage >= 100.0;
    }
}

