// ----------------------------------------------------------------------
import { _mock } from './_mock';

export const AI_ASSISTANT_STATUS_OPTIONS = [
  { value: 'active', label: 'Actif' },
  { value: 'inactive', label: 'Inactif' },
];

export const AI_ASSISTANT_TYPE_OPTIONS = [
  { value: 'japprends', label: "J'apprends" },
  { value: 'accueil', label: 'Accueil' },
  { value: 'recherche', label: 'Recherche' },
];

export const AI_ASSISTANT_EDUCATION_LEVELS = [
  { value: 'CP', label: 'CP' },
  { value: 'CE1', label: 'CE1' },
  { value: 'CE2', label: 'CE2' },
  { value: 'CM1', label: 'CM1' },
  { value: 'CM2', label: 'CM2' },
];

export const AI_ASSISTANT_SUBJECTS = [
  { value: 'Mathématiques', label: 'Mathématiques' },
  { value: 'Français', label: 'Français' },
  { value: 'Histoire', label: 'Histoire' },
  { value: 'Géographie', label: 'Géographie' },
  { value: 'Anglais', label: 'Anglais' },
];

// ----------------------------------------------------------------------

// Création d'exemples d'assistants IA variés, avec un mélange de types
export const mockAIAssistants = [...Array(20)].map((_, index) => {
  // On choisit aléatoirement un type
  const typeIndex = Math.floor(Math.random() * AI_ASSISTANT_TYPE_OPTIONS.length);
  const type = AI_ASSISTANT_TYPE_OPTIONS[typeIndex].value;

  // Génération d'une date aléatoire entre 2023 et 2025
  const randomDate = new Date(2023 + Math.random() * 2, Math.random() * 12, Math.random() * 28);

  // Données de base pour tous les types
  const assistant = {
    id: _mock.id(index),
    name: `Assistant IA ${index + 1}`,
    type: type,
    status: index % 3 ? 'active' : 'inactive',
    educationLevel: AI_ASSISTANT_EDUCATION_LEVELS[index % AI_ASSISTANT_EDUCATION_LEVELS.length].value,
    createdAt: randomDate.toISOString(),
  };

  // Si c'est un type "J'apprends", on ajoute les champs supplémentaires
  if (type === 'japprends') {
    return {
      ...assistant,
      subject: AI_ASSISTANT_SUBJECTS[index % AI_ASSISTANT_SUBJECTS.length].value,
      chapter: `Chapitre ${(index % 10) + 1}`,
      exercise: `Exercice ${(index % 20) + 1}`,
    };
  }

  // Pour les autres types, aucun champ supplémentaire
  return assistant;
});

// Ajouter au moins 5 assistants de type "J'apprends" pour garantir leur présence
for (let i = 0; i < 5; i++) {
  mockAIAssistants[i] = {
    id: _mock.id(i),
    name: `J'apprends ${i + 1}`,
    type: 'japprends',
    status: 'active',
    educationLevel: AI_ASSISTANT_EDUCATION_LEVELS[i % AI_ASSISTANT_EDUCATION_LEVELS.length].value,
    subject: AI_ASSISTANT_SUBJECTS[i % AI_ASSISTANT_SUBJECTS.length].value,
    chapter: `Chapitre ${(i % 10) + 1}`,
    exercise: `Exercice ${(i % 5) + 1}`,
    createdAt: new Date(2023 + Math.random() * 2, Math.random() * 12, Math.random() * 28).toISOString(),
  };
}
