import { _mock } from './_mock';

// ----------------------------------------------------------------------

export const AI_ASSISTANT_STATUS_OPTIONS = [
  { value: 'active', label: 'Actif' },
  { value: 'inactive', label: 'Inactif' },
];

export const EDUCATION_LEVEL_OPTIONS = [
  { value: 'primaire', label: 'Primaire' },
  { value: 'college', label: 'Collège' },
  { value: 'lycee', label: 'Lycée' },
  { value: 'superieur', label: 'Supérieur' },
];

export const AI_TYPE_OPTIONS = [
  { value: 'tutor', label: 'Tuteur' },
  { value: 'quiz', label: 'Quiz' },
  { value: 'exercise', label: 'Exercice' },
  { value: 'assistant', label: 'Assistant' },
];

export const SUBJECT_OPTIONS = [
  { value: 'mathematiques', label: 'Mathématiques' },
  { value: 'physique', label: 'Physique' },
  { value: 'chimie', label: 'Chimie' },
  { value: 'biologie', label: 'Biologie' },
  { value: 'francais', label: 'Français' },
  { value: 'histoire', label: 'Histoire' },
  { value: 'geographie', label: 'Géographie' },
  { value: 'anglais', label: 'Anglais' },
];

// Liste d'assistants AI fictifs
export const _aiAssistantList = [...Array(20)].map((_, index) => ({
  id: _mock.id(index),
  name: `Assistant ${_mock.fullName(index).split(' ')[0]}`,
  educationLevel: EDUCATION_LEVEL_OPTIONS[Math.floor(Math.random() * EDUCATION_LEVEL_OPTIONS.length)].value,
  type: AI_TYPE_OPTIONS[Math.floor(Math.random() * AI_TYPE_OPTIONS.length)].value,
  subject: SUBJECT_OPTIONS[Math.floor(Math.random() * SUBJECT_OPTIONS.length)].value,
  chapter: `Chapitre ${Math.floor(Math.random() * 10) + 1}`,
  exercise: `Exercice ${Math.floor(Math.random() * 20) + 1}`,
  status: Math.random() > 0.3 ? 'active' : 'inactive',
  lastUpdated: _mock.time(index),
  avatarUrl: _mock.image.avatar(index),
  createdBy: _mock.fullName(index + 20),
  parameters: {
    temperature: (Math.random() * 0.7 + 0.3).toFixed(1),
    maxTokens: Math.floor(Math.random() * 2000) + 500,
    topP: (Math.random() * 0.5 + 0.5).toFixed(2),
  },
}));

// Détails d'un assistant AI spécifique
export const _aiAssistantDetails = {
  id: _mock.id(1),
  name: "Assistant Math Expert",
  educationLevel: "lycee",
  type: "tutor",
  subject: "mathematiques",
  chapter: "Chapitre 5: Fonctions exponentielles",
  exercise: "Exercice 3: Applications et problèmes",
  status: "active",
  description: "Assistant spécialisé dans l'aide à la résolution de problèmes mathématiques complexes",
  avatarUrl: _mock.image.avatar(1),
  createdAt: _mock.time(1),
  updatedAt: _mock.time(0),
  createdBy: _mock.fullName(22),
  prompt: "Tu es un assistant spécialisé en mathématiques de niveau lycée. Tu dois guider l'élève dans la résolution de problèmes sans donner la réponse directement...",
  parameters: {
    temperature: 0.7,
    maxTokens: 1500,
    topP: 0.95,
    frequencyPenalty: 0.5,
    presencePenalty: 0.5,
  },
  examples: [
    {
      question: "Comment résoudre l'équation x² - 5x + 6 = 0 ?",
      answer: "Pour résoudre cette équation du second degré, nous allons utiliser la méthode de factorisation. Commençons par identifier si nous pouvons factoriser..."
    },
    {
      question: "Quelle est la dérivée de f(x) = e^x · cos(x) ?",
      answer: "Pour dériver ce produit, nous devons appliquer la formule de dérivation d'un produit. Rappelons que si f(x) = u(x) · v(x), alors f'(x) = u'(x) · v(x) + u(x) · v'(x)..."
    }
  ],
  performance: {
    averageResponseTime: 1.2, // secondes
    userSatisfaction: 4.7, // sur 5
    totalInteractions: 1245,
    successRate: 0.92,
  }
};

// Versions de l'assistant (historique)
export const _aiAssistantVersions = [...Array(5)].map((_, index) => ({
  id: _mock.id(index + 100),
  versionNumber: 5 - index,
  createdAt: _mock.time(index),
  changedBy: _mock.fullName(index + 20),
  changes: [
    "Amélioration de la compréhension des problèmes d'algèbre",
    "Ajout d'exemples supplémentaires",
    "Optimisation des paramètres de température",
    "Correction des erreurs de calcul différentiel"
  ].slice(0, Math.floor(Math.random() * 3) + 1),
}));

// Feedback sur l'assistant
export const _aiAssistantFeedback = [...Array(8)].map((_, index) => ({
  id: _mock.id(index + 200),
  userName: _mock.fullName(index + 40),
  userAvatarUrl: _mock.image.avatar(index + 40),
  rating: Math.floor(Math.random() * 3) + 3, // 3 à 5 étoiles
  comment: [
    "Très utile pour comprendre les concepts difficiles.",
    "Les explications sont claires et adaptées à mon niveau.",
    "J'aurais aimé plus d'exemples concrets.",
    "M'a vraiment aidé à préparer mon examen.",
    "Parfois les réponses sont un peu longues.",
  ][Math.floor(Math.random() * 5)],
  createdAt: _mock.time(index),
}));