import Box from '@mui/material/Box';

// ----------------------------------------------------------------------

type Props = {
  label: string;
  isShow: boolean;
  children: React.ReactNode;
};

export function FiltersBlock({ label, isShow, children }: Props) {
  if (!isShow) {
    return null;
  }

  return (
    <Box display="flex" alignItems="center" flexWrap="wrap" gap={1}>
      <Box component="span" sx={{ typography: 'subtitle2' }}>
        {label}
      </Box>

      {children}
    </Box>
  );
}