import { IAIAssistantItem } from 'src/types/ai-assistant';
export function updateAssistantsWithFakeDates() {
    const assistants = JSON.parse(localStorage.getItem('assistants') || '[]');
    const updatedAssistants = assistants.map((assistant: IAIAssistantItem) => {
      if (!assistant.createdAt || assistant.createdAt === "-") {
        // Assigner une date factice (entre 2023 et 2025)
        assistant.createdAt = new Date(
          2023 + Math.random() * 2, 
          Math.floor(Math.random() * 12), 
          Math.floor(Math.random() * 28) + 1
        ).toISOString();
      }
      return assistant;
    });
    localStorage.setItem('assistants', JSON.stringify(updatedAssistants));
  }