// D:\bureau\PFA\dev\back_office\interface\src\shared\sections\personalization-ai\ai-assistant-table-toolbar.tsx

import type { IAIAssistantTableFilters } from 'src/types/ai-assistant';
import type { SelectChangeEvent } from '@mui/material/Select';
import type { UseSetStateReturn } from 'src/hooks/use-set-state';

import { useCallback, useMemo } from 'react';
import Stack from '@mui/material/Stack';
import Grid from '@mui/material/Grid';
import Paper from '@mui/material/Paper';
import Select from '@mui/material/Select';
import Button from '@mui/material/Button';
import MenuList from '@mui/material/MenuList';
import MenuItem from '@mui/material/MenuItem';
import TextField from '@mui/material/TextField';
import InputLabel from '@mui/material/InputLabel';
import IconButton from '@mui/material/IconButton';
import FormControl from '@mui/material/FormControl';
import OutlinedInput from '@mui/material/OutlinedInput';
import InputAdornment from '@mui/material/InputAdornment';
import Divider from '@mui/material/Divider';
import Box from '@mui/material/Box';
import Tooltip from '@mui/material/Tooltip';
import { Iconify } from 'src/shared/components/iconify';
import { usePopover, CustomPopover } from 'src/shared/components/custom-popover';
import { AI_ASSISTANT_CHAPTERS, AI_ASSISTANT_EXERCISES } from '../../../_mock/_ai-assistant';

//----------------------------------------------------------------------
type Props = {
  onResetPage: () => void;
  filters: UseSetStateReturn<IAIAssistantTableFilters>;
  options: {
    types: {
      value: string;
      label: string;
    }[];
    educationLevels: {
      value: string;
      label: string;
    }[];
    subjects: {
      value: string;
      label: string;
    }[];
    statuses: {
      value: string;
      label: string;
    }[];
  };
  onFilterChange: (filterName: string, value: string | string[]) => void;
  onClearFilters: () => void;
};

export function AIAssistantTableToolbar({ 
  filters, 
  options, 
  onResetPage, 
  onFilterChange,
  onClearFilters 
}: Props) {
  const popover = usePopover();
  
  const isJapprendsSelected = useMemo(() => 
    filters.state.type.includes('japprends'), 
    [filters.state.type]
  );

  const handleFilterChange = useCallback(
    (filterName: string, value: string | string[]) => {
      onResetPage();
      onFilterChange(filterName, value);
    },
    [onResetPage, onFilterChange]
  );

  return (
    <>
      <Paper
        elevation={0}
        sx={{
          p: 2.5,
          mb: 3,
          borderRadius: 2,
          bgcolor: 'background.neutral',
        }}
      >
        <Grid container spacing={2}>
          <Grid item xs={12} md={4}>
            <TextField
              fullWidth
              size="small"
              value={filters.state.name}
              onChange={(e) => handleFilterChange('name', e.target.value)}
              placeholder="Rechercher par nom..."
              InputProps={{
                startAdornment: (
                  <InputAdornment position="start">
                    <Iconify icon="eva:search-fill" sx={{ color: 'text.disabled' }} />
                  </InputAdornment>
                ),
              }}
            />
          </Grid>
          
          <Grid item xs={12} md={8}>
            <Stack direction={{ xs: 'column', sm: 'row' }} spacing={2}>
              <FormControl fullWidth size="small">
                <InputLabel>Type</InputLabel>
                <Select
                  multiple
                  value={filters.state.type}
                  onChange={(e) => handleFilterChange('type', e.target.value)}
                  input={<OutlinedInput label="Type" />}
                  renderValue={(selected) => selected.map((value) => 
                    options.types.find((type) => type.value === value)?.label || value
                  ).join(', ')}
                >
                  {options.types.map((option) => (
                    <MenuItem key={option.value} value={option.value}>{option.label}</MenuItem>
                  ))}
                </Select>
              </FormControl>
              
              <FormControl fullWidth size="small">
                <InputLabel>Niveau Scolaire</InputLabel>
                <Select
                  value={filters.state.educationLevel || ''}
                  onChange={(e) => handleFilterChange('educationLevel', e.target.value)}
                  input={<OutlinedInput label="Niveau Scolaire" />}
                >
                  <MenuItem value="">Tous</MenuItem>
                  {options.educationLevels.map((option) => (
                    <MenuItem key={option.value} value={option.value}>{option.label}</MenuItem>
                  ))}
                </Select>
              </FormControl>
              
              <FormControl fullWidth size="small">
                <InputLabel>Statut</InputLabel>
                <Select
                  value={filters.state.status || ''}
                  onChange={(e) => handleFilterChange('status', e.target.value)}
                  input={<OutlinedInput label="Statut" />}
                >
                  <MenuItem value="">Tous</MenuItem>
                  {options.statuses.map((option) => (
                    <MenuItem key={option.value} value={option.value}>{option.label}</MenuItem>
                  ))}
                </Select>
              </FormControl>
            </Stack>
          </Grid>
          
          {isJapprendsSelected && (
            <Grid item xs={12}>
              <Stack direction={{ xs: 'column', sm: 'row' }} spacing={2}>
                {/* Sélection de la matière */}
                <FormControl fullWidth size="small">
                  <InputLabel>Matière</InputLabel>
                  <Select
                    name="subject"
                    value={filters.state.subject || ''}
                    onChange={(e) => handleFilterChange('subject', e.target.value)}
                    input={<OutlinedInput label="Matière" />}
                  >
                    <MenuItem value="">Toutes</MenuItem>
                    {options.subjects.map((option) => (
                      <MenuItem key={option.value} value={option.value}>{option.label}</MenuItem>
                    ))}
                  </Select>
                </FormControl>

                {/* Affichage conditionnel du champ "Chapitre" */}
                {filters.state.subject && (
                  <FormControl fullWidth size="small">
                    <InputLabel>Chapitre</InputLabel>
                    <Select
                      name="chapter"
                      value={filters.state.chapter || ''}
                      onChange={(e) => handleFilterChange('chapter', e.target.value)}
                      input={<OutlinedInput label="Chapitre" />}
                    >
                      <MenuItem value="">Tous</MenuItem>
                      {AI_ASSISTANT_CHAPTERS.map((option) => (
                        <MenuItem key={option.value} value={option.value}>
                          {option.label}
                        </MenuItem>
                      ))}
                    </Select>
                  </FormControl>
                )}

                {/* Affichage conditionnel du champ "Exercice" */}
                {filters.state.subject && filters.state.chapter && (
                  <FormControl fullWidth size="small">
                    <InputLabel>Exercice</InputLabel>
                    <Select
                      name="exercise"
                      value={filters.state.exercise || ''}
                      onChange={(e) => handleFilterChange('exercise', e.target.value)}
                      input={<OutlinedInput label="Exercice" />}
                    >
                      <MenuItem value="">Tous</MenuItem>
                      {AI_ASSISTANT_EXERCISES.map((option) => (
                        <MenuItem key={option.value} value={option.value}>
                          {option.label}
                        </MenuItem>
                      ))}
                    </Select>
                  </FormControl>
                )}
              </Stack>
            </Grid>
          )}
        </Grid>
      </Paper>
      <CustomPopover
        open={popover.open}
        anchorEl={popover.anchorEl}
        onClose={popover.onClose}
        slotProps={{ arrow: { placement: 'right-top' } }}
      >
        <MenuList>
          <MenuItem
            onClick={() => {
              popover.onClose();
            }}
          >
            <Iconify icon="solar:printer-minimalistic-bold" />
            Imprimer
          </MenuItem>
          <MenuItem
            onClick={() => {
              popover.onClose();
            }}
          >
            <Iconify icon="solar:import-bold" />
            Importer
          </MenuItem>
          <MenuItem
            onClick={() => {
              popover.onClose();
            }}
          >
            <Iconify icon="solar:export-bold" />
            Exporter
          </MenuItem>
        </MenuList>
      </CustomPopover>
    </>
  );
}