export type UserType = Record<string, any> | null;

export type AuthState = {
  user: UserType;
  loading: boolean;
};

export type AuthContextValue = {
  user: UserType;
  loading: boolean;
  authenticated: boolean;
  unauthenticated: boolean;
  checkUserSession?: () => Promise<void>;
  newPassword?: (password: string) => Promise<void>;
  forgotPassword?: (email: string) => Promise<void>;
  
  verifyResetCode?: (email: string, code: string) => Promise<void>;
};
