export interface IRoleItem {
  id: number;
  name: string;
  description: string;
  permissions: Permission[];
  createdAt: Date;
}
export interface IRoleRequest {
  name: string;
  description: string;
  permissions: Permission[];
}

export interface IRoleTableFilters {
  name: string;
  description: string;
  permissions: Permission[];
  createdAt: Date;
}
export interface Pageable<T> {
  content: T[];
  totalElements: number;
  totalPages: number;
  size: number;
  number: number;
  first: boolean;
  last: boolean;
  empty: boolean;
  sort: {
    empty: boolean;
    sorted: boolean;
    unsorted: boolean;
  };
  offset: number;
  pageNumber: number;
  pageSize: number;
  paged: boolean;
  unpaged: boolean;
  numberOfElements: number;
}
export type IRolePageable = Pageable<IRoleItem>;
export interface RolePageFilterParams {
  page?: number;
  size?: number;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
}
export type PermissionType = 'CREATE' | 'READ' | 'UPDATE' | 'DELETE' | 'IMPORT' | 'EXPORT';

export type Permission = {
  subModule: string;
  permissionType: PermissionType;
};

export const allModules = [
  { label: 'Acceuil', value: 'Home' },
  { label: "Statistiques d'usage", value: 'UsageStatistics' },
  { label: 'Performances des utilisateurs', value: 'UserPerformance' },
  { label: 'Suivi des erreurs', value: 'ErrorTracking' },
  { label: 'Logs et Traçabilité', value: 'Logs' },
  { label: 'Comptes', value: 'Accounts' },
  { label: 'Gestion rôles et permissions', value: 'RolesPermissions' },
  { label: "Gestion d'apprentissage", value: 'LearningManagement' },
  { label: 'Gestion des challenges', value: 'ChallengeManagement' },
  { label: 'Ressources multimedias', value: 'MultimediaResources' },
  { label: 'Gestion des améliorations', value: 'ImprovementsManagement' },
  { label: 'Abonnements', value: 'PlanManagement' },
  { label: 'Suivi & Facturation', value: 'TrackingBilling' },
  { label: 'Configuration des paiements', value: 'PaymentConfiguration' },
  { label: 'Notifications', value: 'Notifications' },
  { label: 'Gestion des FAQs', value: 'FAQManagement' },
  { label: 'Gestion des tickets', value: 'TicketManagement' },
  { label: 'Configuration du chatbot', value: 'ChatbotConfiguration' },
  { label: 'Configurations', value: 'Settings' },
  { label: 'Tableau de bord', value: 'Dashboard' },
  { label: 'Correction', value: 'CorrectionModule' },
  { label: 'Taux', value: 'RatesModule' },
  { label: 'Performance', value: 'PerformanceModule' },
  { label: 'Gestion des assistants', value: 'AssistantManagement' },
  { label: 'Modération et signalement', value: 'ModerationReporting' },
  { label: 'Audits', value: 'AuditsModule' },
];

export const allPermissions = [
  { label: 'Lecture', value: 'READ' },
  { label: 'Ajout', value: 'CREATE' },
  { label: 'Modification', value: 'UPDATE' },
  { label: 'Suppression', value: 'DELETE' },
  { label: 'Export', value: 'EXPORT' },
  { label: 'Import', value: 'IMPORT' },
];
export function getSubModuleLabelByValue(value: string): string {
  const module = allModules.find((mod) => mod.value === value);
  return module?.label ?? value;
}
export function getPermissionTypeLabelByValue(value: string): string {
  const permission = allPermissions.find((mod) => mod.value === value);
  return permission?.label ?? value;
}
