import {
  allModules,
  allPermissions,
  type IRoleItem,
  type Permission,
} from 'src/contexts/types/role';

const roleData: IRoleItem[] = [
  {
    id: 1,
    name: 'Admin',
    description: "Utilisateur ayant tous les droits d'administration.",
    permissions: allModules.flatMap((module) =>
      allPermissions.map((perm) => ({
        subModule: module.value,
        permissionType: perm.value as Permission['permissionType'],
      }))
    ),
    createdAt: new Date('2022-01-01T10:00:00Z'),
  },
  {
    id: 2,
    name: 'Super-admin',
    description: 'Utilisateur avec un accès complet et la possibilité de gérer les utilisateurs.',
    permissions: allModules.flatMap((module) =>
      allPermissions
        .filter((perm) => perm.value !== 'IMPORT')
        .map((perm) => ({
          subModule: module.value,
          permissionType: perm.value as Permission['permissionType'],
        }))
    ),
    createdAt: new Date('2022-02-15T09:30:00Z'),
  },
  ...Array.from({ length: 20 }, (_, i) => ({
    id: 7 + i,
    name: `Role-${7 + i}`,
    description: `Description du rôle ${7 + i}.`,
    permissions: allPermissions.slice(0, (i % allPermissions.length) + 1).map((perm) => ({
      subModule: allModules[0].value,
      permissionType: perm.value as Permission['permissionType'],
    })),
    createdAt: new Date(new Date().setDate(new Date().getDate() - (i + 1))),
  })),
];

export default roleData;
