import axios from 'axios';

import { IParent } from 'src/contexts/types/user';
import { userEndpoints } from 'src/shared/api/endpoints/user';

export interface Permission {
  id: string;
  subModule: string;
  permissionType: string;
  createdAt: string;
}

export interface Role {
  id: string;
  name: string;
  description: string;
  permissions: Permission[];
  createdAt: string;
}

export const userService = {
  async getParent(id: string): Promise<IParent> {
    try {
      const response = await axios({
        method: 'get',
        url: userEndpoints.user.parent.details.replace(':id', id),
        headers: { 'Content-Type': 'application/json' },
      });

      return response.data;
    } catch (error) {
      console.error('Erreur lors de la récupération des rôles:', error);
      throw error;
    }
  },
  async getChild(id: string): Promise<IParent> {
    try {
      const response = await axios({
        method: 'get',
        url: userEndpoints.user.child.details.replace(':id', id),
        headers: { 'Content-Type': 'application/json' },
      });

      return response.data;
    } catch (error) {
      console.error('Erreur lors de la récupération des rôles:', error);
      throw error;
    }
  },
  async getAdmin(id: string): Promise<IParent> {
    try {
      const response = await axios({
        method: 'get',
        url: userEndpoints.user.admin.details.replace(':id', id),
        headers: { 'Content-Type': 'application/json' },
      });

      return response.data;
    } catch (error) {
      console.error('Erreur lors de la récupération des rôles:', error);
      throw error;
    }
  },
};

export const apiService = {
  user: userService,
};

export default apiService;
