import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faSyncAlt, faColumns, faFileExport } from '@fortawesome/free-solid-svg-icons';

import { Stack, Button, Tooltip } from '@mui/material';
import {
  GridToolbarExport,
  useGridApiContext,
  GridToolbarContainer,
  GridToolbarFilterButton,
  GridToolbarColumnsButton,
} from '@mui/x-data-grid';

interface CustomToolbarProps {
  setFilterButtonEl: React.Dispatch<React.SetStateAction<HTMLButtonElement | null>>;
}

const CustomToolbar = ({ setFilterButtonEl }: CustomToolbarProps) => {
  const apiRef = useGridApiContext();

  // Function to reset filters and column visibility
  const handleReset = () => {
    if (apiRef.current) {
      // Reset filters
      apiRef.current.setFilterModel({ items: [] });

      // Reset column visibility
      const allColumns = apiRef.current.getAllColumns();
      const columnVisibilityModel = allColumns.reduce(
        (acc, column) => {
          acc[column.field] = true;
          return acc;
        },
        {} as Record<string, boolean>
      );
      apiRef.current.setColumnVisibilityModel(columnVisibilityModel);
    }
  };
  return (
    <GridToolbarContainer>
      <Stack spacing={1} flexGrow={1} direction="row" alignItems="center" justifyContent="flex-end">
        <GridToolbarColumnsButton
          slotProps={{
            tooltip: { title: 'Sélectionner colonnes' },
            button: {
              variant: 'outlined',
              startIcon: <FontAwesomeIcon icon={faColumns} />,
              sx: {
                color: 'primary.contrastText',
                backgroundColor: 'primary.main',
                '&:hover': {
                  backgroundColor: 'primary.dark',
                },
              },
            },
          }}
        />

        <GridToolbarFilterButton
          ref={setFilterButtonEl}
          slotProps={{
            button: {
              sx: {
                padding: '4px',
                minWidth: 'auto',
                '& .MuiButton-startIcon': { mr: 0 },
                '& .MuiButton-endIcon': { ml: 0 },
                '& .MuiButton-text': { ml: 0 },
                color: 'primary.main',
              },
            },
          }}
        />

        {/* Reset Button */}
        <Tooltip title="Réinitialiser" arrow>
          <Button
            size="small"
            color="secondary"
            startIcon={<FontAwesomeIcon icon={faSyncAlt} />}
            onClick={handleReset}
            sx={{
              padding: '4px',
              minWidth: 'auto',
              '& .MuiButton-startIcon': { mr: 0 },
              '& .MuiButton-endIcon': { ml: 0 },
              '& .MuiButton-text': { ml: 0 },
              color: 'primary.main',
              '&:hover': {
                backgroundColor: 'rgba(0, 0, 0, 0.04)',
              },
            }}
          />
        </Tooltip>

        <GridToolbarExport
          printOptions={{ disableToolbarButton: true }}
          slotProps={{
            button: {
              sx: {
                padding: '4px',
                minWidth: 'auto',
                '& .MuiButton-startIcon': { mr: 0 },
                '& .MuiButton-endIcon': { ml: 0 },
                '& .MuiButton-text': { ml: 0 },
                color: 'primary.main',
              },
              startIcon: <FontAwesomeIcon icon={faFileExport} />,
            },
          }}
        />
      </Stack>
    </GridToolbarContainer>
  );
};

export default CustomToolbar;
