# MC-Intra Kubernetes Manifests

Ce dépôt centralise tous les manifests Kubernetes pour les microservices du projet MC-Intra.

## Structure du Projet

```
mc-intra-k8s-manifests/
├── apps/                    # Manifests des microservices
│   ├── administration-service/
│   │   └── staging/
│   ├── api/                 # API Gateway
│   │   └── staging/
│   ├── config-service/
│   │   └── staging/
│   ├── deployment-service/
│   │   └── staging/
│   ├── documentation-service/
│   │   └── staging/
│   ├── engagement-service/
│   │   └── staging/
│   ├── front/               # Frontend application
│   │   └── staging/
│   ├── logging-service/
│   │   └── staging/
│   ├── search-service/
│   │   └── staging/
│   └── user-service/
│       └── staging/
├── argocd/                  # Configurations ArgoCD
│   ├── applications/
│   │   └── staging/         # Applications ArgoCD pour staging
│   └── projects/            # Projets ArgoCD
└── kubectl                  # Scripts kubectl utilitaires
```

## Microservices

Chaque microservice dans le dossier `apps/` contient les configurations pour l'environnement staging :
- `staging/` - Environnement de staging

### Services disponibles

| Service | Description | Port | Image | ArgoCD App |
|---------|-------------|------|-------|------------|
| **api** | API Gateway | 8080 | `marketingconfort/mc-intra-api:latest` | `api-gateway` |
| **front** | Frontend Application | 3000 | `marketingconfort/mc-intra-front:latest` | `front` |
| **user-service** | Service de gestion des utilisateurs | 8081 | `marketingconfort/mc-intra-user-service:latest` | `user-service` |
| **administration-service** | Service d'administration | 8082 | `marketingconfort/mc-intra-administration-service:latest` | `administration-service` |
| **config-service** | Service de configuration | 8083 | `marketingconfort/mc-intra-config-service:latest` | `config-service` |
| **deployment-service** | Service de déploiement | 8084 | `marketingconfort/mc-intra-deployment-service:latest` | `deployment-service` |
| **documentation-service** | Service de documentation | 8085 | `marketingconfort/mc-intra-documentation-service:latest` | `documentation-service` |
| **engagement-service** | Service d'engagement | 8086 | `marketingconfort/mc-intra-engagement-service:latest` | `engagement-service` |
| **logging-service** | Service de logging | 8087 | `marketingconfort/mc-intra-logging-service:latest` | `logging-service` |
| **search-service** | Service de recherche | 8088 | `marketingconfort/mc-intra-search-service:latest` | `search-service` |

## ArgoCD Applications

Le dossier `argocd/applications/staging/` contient toutes les applications ArgoCD pour l'environnement de staging :

### Applications disponibles

| Application | Service | Path | Sync Policy |
|-------------|---------|------|-------------|
| `api-gateway` | API Gateway | `apps/api/staging` | Automatique |
| `front` | Frontend | `apps/front/staging` | Automatique |
| `user-service` | User Service | `apps/user-service/staging` | Automatique |
| `administration-service` | Administration Service | `apps/administration-service/staging` | Automatique |
| `config-service` | Config Service | `apps/config-service/staging` | Automatique |
| `deployment-service` | Deployment Service | `apps/deployment-service/staging` | Automatique |
| `documentation-service` | Documentation Service | `apps/documentation-service/staging` | Automatique |
| `engagement-service` | Engagement Service | `apps/engagement-service/staging` | Automatique |
| `logging-service` | Logging Service | `apps/logging-service/staging` | Automatique |
| `search-service` | Search Service | `apps/search-service/staging` | Automatique |

### Configuration ArgoCD

Toutes les applications ArgoCD sont configurées avec :
- **Sync automatique** activé
- **Prune** activé (suppression automatique des ressources orphelines)
- **Self-heal** activé (correction automatique des dérives)
- **CreateNamespace** activé (création automatique du namespace si nécessaire)

## Infrastructure

Le projet utilise :
- **Namespace** : `mc-intra` pour tous les services
- **ArgoCD** pour la gestion des déploiements GitOps
- **Kubernetes** comme plateforme d'orchestration

## Déploiement

### Prérequis
- Kubernetes cluster v1.20+
- ArgoCD installé et configuré
- Accès kubectl configuré
- Accès au registry Docker `marketingconfort`

### Déploiement via ArgoCD

1. **Créer le projet ArgoCD** :
   ```bash
   kubectl apply -f argocd/projects/
   ```

2. **Déployer les applications** :
   ```bash
   kubectl apply -f argocd/applications/staging/
   ```

3. **Vérifier le statut** :
   ```bash
   kubectl get applications -n argocd
   kubectl get pods -n mc-intra
   ```

### Déploiement manuel

Pour déployer un service individuellement :
```bash
kubectl apply -f apps/{service-name}/staging/
```

## Monitoring et Debugging

### Vérifier le statut des pods
```bash
kubectl get pods -n mc-intra
```

### Consulter les logs d'un service
```bash
kubectl logs -f deployment/{service-name} -n mc-intra
```

### Décrire un pod pour diagnostiquer les problèmes
```bash
kubectl describe pod {pod-name} -n mc-intra
```

### Vérifier les événements du namespace
```bash
kubectl get events -n mc-intra --sort-by='.lastTimestamp'
```

## Troubleshooting

### Problèmes courants

1. **Pod en état Error** :
   - Vérifier les logs du pod
   - Vérifier l'existence de l'image Docker
   - Vérifier les variables d'environnement

2. **ImagePullBackOff** :
   - Vérifier les credentials du registry
   - Vérifier l'existence de l'image

3. **CrashLoopBackOff** :
   - Consulter les logs de l'application
   - Vérifier la configuration de l'application

## Contribution

Pour ajouter un nouveau service :

1. Créer le dossier `apps/{service-name}/staging/`
2. Ajouter les manifests Kubernetes (deployment, service, etc.)
3. Créer l'application ArgoCD correspondante dans `argocd/applications/staging/`
4. Mettre à jour ce README avec les informations du nouveau service


