#!/bin/bash

apt-get update && apt-get install -y curl jq

CHANGELOG_UPDATED=false

FILES=$(curl --header "PRIVATE-TOKEN: $GITLAB_API_TOKEN" "https://mc-git.com/api/v4/projects/$CI_PROJECT_ID/merge_requests/$CI_MERGE_REQUEST_IID/changes" | jq -r '.changes[] | .old_path, .new_path')

for file in $FILES; do
  if [[ "$file" == "CHANGELOG.md" ]]; then
    CHANGELOG_UPDATED=true
    echo "CHANGELOG.md has been successfully updated in this merge request."
    break
  fi
done

if [ "$CHANGELOG_UPDATED" == "false" ]; then
  echo "CHANGELOG.md must be updated in every merge request."
  exit 1
fi
