#!/bin/bash

# Check for unauthorized changes in pom.xml

apt-get update && apt-get install -y curl jq xmlstarlet

POM_UPDATED=false
INVALID_CHANGE=false
VERSION_MODIFIED=false

# Fetch the changed files in the merge request
FILES=$(curl --header "PRIVATE-TOKEN: $GITLAB_API_TOKEN" "https://mc-git.com/api/v4/projects/$CI_PROJECT_ID/merge_requests/$CI_MERGE_REQUEST_IID/changes" | jq -r '.changes[] | .new_path')

# Fetch the original version of the pom.xml file from the target branch (e.g., develop)
ORIGINAL_POM=$(curl --header "PRIVATE-TOKEN: $GITLAB_API_TOKEN" "https://mc-git.com/api/v4/projects/$CI_PROJECT_ID/repository/files/pom.xml/raw?ref=develop")
ORIGINAL_VERSION=$(echo "$ORIGINAL_POM" | xmlstarlet sel -t -v "/_:project/_:version")

# Fetch the content of the pom.xml file in the current commit
CURRENT_POM=$(curl --header "PRIVATE-TOKEN: $GITLAB_API_TOKEN" "https://mc-git.com/api/v4/projects/$CI_PROJECT_ID/repository/files/pom.xml/raw?ref=$CI_COMMIT_REF_NAME")
CURRENT_VERSION=$(echo "$CURRENT_POM" | xmlstarlet sel -t -v "/_:project/_:version")

for file in $FILES; do
  if [[ "$file" == "pom.xml" ]]; then
    POM_UPDATED=true
    # Check if the version has been modified
    if [ "$ORIGINAL_VERSION" != "$CURRENT_VERSION" ]; then
      VERSION_MODIFIED=true
      break
    fi
  fi
done

if [ "$POM_UPDATED" == "true" ] && [ "$VERSION_MODIFIED" == "true" ]; then
  echo "Unauthorized version change detected in pom.xml. The version must remain as '$ORIGINAL_VERSION'."
  exit 1
fi
