package com.marketingconfort.tickets.common.models;

import jakarta.persistence.*;
import jakarta.validation.constraints.Email;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;


@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
public class Contact {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    private String fullName;
    @Email
    private String email;
    private String address;
    private String timeZone;
    private String language;
    private String phoneNumber;
    @OneToMany
    private List<Ticket> tickets;

}
