package com.marketingconfort.tickets.common.models;


import com.marketingconfort.tickets.common.enums.TicketPriority;
import com.marketingconfort.tickets.common.enums.TicketType;
import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;


@Getter
@Setter
@MappedSuperclass
public abstract class StandardTicket {


    @Column(unique = true)
    private String title;

    @Enumerated(EnumType.STRING)
    private TicketPriority priority;

    private String status;

    @Enumerated(EnumType.STRING)
    private TicketType type;

    private String description;

    @ManyToOne
    private Contact contact;

    private String requestNature;

    private String concernedService;

    private Long userId;

    private String source;

    private LocalDateTime date;
    private Long teamId;

}
