package com.marketingconfort.tickets.common.models;


import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
@Entity
public class Ticket extends StandardTicket{

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private String email;
    private LocalDateTime lastModif;
    private LocalDateTime assignDate;

    @ElementCollection
    private List<String> carbonCopyMails;

    @OneToMany(mappedBy = "ticket", cascade = CascadeType.ALL)
    private List<TicketTrigger> ticketTriggers;


    @OneToMany(mappedBy = "ticket", cascade = CascadeType.ALL, orphanRemoval = true)
    private List<History> histories = new ArrayList<>();

    @OneToMany(mappedBy = "ticket", cascade = CascadeType.ALL, orphanRemoval = true)
    private List<Comment> comments;


    @ManyToOne
    private KanbanColumn kanbanColumn;

}
