/* eslint-disable perfectionist/sort-imports */
import './globals.css';

// i18n
import '@/locales/i18n';
// ----------------------------------------------------------------------

import ThemeProvider from '@/shared/theme';
import { primaryFont } from '@/shared/theme/typography';

import ProgressBar from '@/shared/components/progress-bar';
import { MotionLazy } from '@/shared/components/animate/motion-lazy';
import SnackbarProvider from '@/shared/components/snackbar/snackbar-provider';
import { SettingsDrawer, SettingsProvider } from '@/shared/components/settings';
import { AuthProvider } from '@/contexts/auth/jwt';
import { AgencyUpdatesProvider } from '@/contexts/agency-updates-context';

// ----------------------------------------------------------------------

export const viewport = {
  themeColor: '#000000',
  width: 'device-width',
  initialScale: 1,
  maximumScale: 1,
};

export const metadata = {
  title: 'Dashbord',
  description:
    'The starting point for your next project with Minimal UI Kit, built on the newest version of Material-UI ©, ready to be customized to your style',
  keywords: 'react,material,kit,application,dashboard,admin,template',
  manifest: '/manifest.json',
  icons: [
    { rel: 'icon', url: '/favicon/favicon.ico' },
    { rel: 'icon', type: 'image/png', sizes: '16x16', url: '/favicon/favicon-16x16.png' },
    { rel: 'icon', type: 'image/png', sizes: '32x32', url: '/favicon/favicon-32x32.png' },
    { rel: 'apple-touch-icon', sizes: '180x180', url: '/favicon/apple-touch-icon.png' },
  ],
};

type Props = {
  children: React.ReactNode;
};

export default function RootLayout({ children }: Props) {
  return (
    <html lang="en" className={primaryFont.className}>
    <body>
        <AgencyUpdatesProvider>
          <AuthProvider>
            <SettingsProvider
              defaultSettings={{
                themeMode: 'light', // 'light' | 'dark'
                themeDirection: 'ltr', //  'rtl' | 'ltr'
                themeContrast: 'default', // 'default' | 'bold'
                themeLayout: 'horizontal', // 'vertical' | 'horizontal' | 'mini'
                themeColorPresets: 'default', // 'default' | 'cyan' | 'purple' | 'blue' | 'orange' | 'red'
                themeStretch: false,
              }}
            >
              <ThemeProvider>
                <MotionLazy>
                <SnackbarProvider>
                  <SettingsDrawer />
                  <ProgressBar />
                  {children}
                    </SnackbarProvider>
                </MotionLazy>
              </ThemeProvider>
            </SettingsProvider>
          </AuthProvider>
        </AgencyUpdatesProvider>
      </body>
    </html>
  );
}