import { Participants } from "./Project";
import { ITaskItem } from "./tasks";

export type IRewardItem = {
    id: string;
    title: string,
    description: string,
    startDate: Date,
    endDate: Date,
    status: string,
    authorName: string,
    authorEmail : string, 
    authorPhoneNumber: number, 
    rule:string,
    price:number,
    tasks:ITaskItem[]
    winners:IRewardWninners
};
export type Author = {
    id: string;
    name: string;
    authorName: string; 
    avatarUrl: string;
    phoneNumber: string;
    email:string
    role: string,

};
export type IRewardFilter = {
   
    status: string;
  

}
export type IWinnerFilter={
  Reward:string,
  name:string



}
export type IRewardWninners={
    id: string;
    name: string;
    avatarUrl: string;
    phoneNumber: string;
    email:string
    role: string,
    note:number,
    reward:boolean|undefined
}

export type IRewardFilterValue = string | string[] | Date | null|boolean|undefined;