import { memo } from 'react';

import AppBar from '@mui/material/AppBar';
import Toolbar from '@mui/material/Toolbar';
import { alpha, useTheme } from '@mui/material/styles';

import { useMockedUser } from '@/hooks';
import { usePathname } from 'next/navigation';
import { bgBlur } from '@/shared/theme/css';

import Scrollbar from '@/shared/components/scrollbar';
import { NavSectionHorizontal } from '@/shared/components/nav-section';

import { HEADER } from '../config-layout';
import { useNavData } from './config-navigation';
import HeaderShadow from '../common/header-shadow';

// ----------------------------------------------------------------------

function NavHorizontal() {
  const theme = useTheme();

  const { user1 } = useMockedUser();
  const pathname = usePathname();
  const navData = useNavData();

  return (
    <AppBar
      component="div"
      sx={{
        top: HEADER.H_DESKTOP_OFFSET,
      }}
    >
      <Toolbar
        sx={{
          ...bgBlur({
            color: theme.palette.background.default,
          }),
        }}
      >
        <Scrollbar
          sx={{
            '& .simplebar-content': {
              display: 'flex',
            },
          }}
        >
           <NavSectionHorizontal
            data={navData}
            slotProps={{
              currentRole: user1?.role,
              currentPath: pathname,
            }}
            sx={{
              ...theme.mixins.toolbar,
              '& .MuiListItemButton-root.active': {
                backgroundColor: alpha('#144dd5', 0.08),
                border: `2px solid ${alpha('#144dd5', 0.24)}`,
                borderRadius: 1,
                color: 'primary.main',
                '&:hover': {
                  backgroundColor: alpha('#144dd5', 0.16),
                  borderColor: alpha('#144dd5', 0.32),
                },
                '& .MuiListItemIcon-root': {
                  color: '#144dd5',
                },
              },
              '&[data-active="true"]': {
                  backgroundColor: alpha('#144dd5', 0.08),
                  border: '2px solid #144dd5',
                  borderRadius: 1,
                  color: '#144dd5',
                  fontWeight: 'bold',
                  '&:hover': {
                    backgroundColor: alpha('#144dd5', 0.16),
                    border: '2px solid #144dd5',
                  },
                  '& .MuiListItemIcon-root': {
                    color: '#144dd5',
                  },
                },
              
              '& .MuiListItemButton-root': {
                borderRadius: 1,
                border: '2px solid #144dd5',
                '&:hover': {
                  backgroundColor: alpha('#144dd5', 0.08),
                  color: '#144dd5',
                  '& .MuiListItemIcon-root': {
                    color: '#144dd5',
                  },
                },
              },

            }}
          />
        </Scrollbar>
      </Toolbar>

      <HeaderShadow />
    </AppBar>
  );
}

export default memo(NavHorizontal);
