'use client';

import Box from '@mui/material/Box';
import { alpha } from '@mui/material/styles';
import Container from '@mui/material/Container';
import Typography from '@mui/material/Typography';

import { paths } from '@/routes/paths';
import { useSettingsContext } from '@/shared/components/settings';
import CustomBreadcrumbs from '@/components/custom-breadcrumbs';
import   TaskNewEditForm   from './task-new-edit-form';

// ----------------------------------------------------------------------

export default function AddTaskView() {
  const settings = useSettingsContext();

  return (
    <Container maxWidth={settings.themeStretch ? false : 'lg'}>
      <CustomBreadcrumbs
        heading="Create a new task"
        links={[
          {
            name: 'Dashboard',
            href: paths.dashboard.root,
          },
          {
            name: 'Tasks',
            href: paths.dashboard.tasks.all_tasks,
          },
          { name: 'New task' },
        ]}
        sx={{
          mb: { xs: 3, md: 5 },
        }}
      />
      <TaskNewEditForm onChangePriority={function (newValue: string): void {
        throw new Error('Function not implemented.');
      } } />
    </Container>
  );
}
