import { IAgency } from "@/shared/types/agency";
import { Card, Divider, ListItemText, Stack, Typography } from "@mui/material";
import { fDate } from "@/utils/format-time";
import Grid from "@mui/material/Unstable_Grid2/Grid2";
type Props = {
  agency: IAgency | null;
};

const AgencyGeneralView = ({ agency }: Props) => {
  if (!agency) {
    return <Typography color="error">Agency not found.</Typography>;
  }
  

  return (
    <Grid container spacing={5} disableEqualOverflow>
      <Grid xs={12} md={8}>
        <Card sx={{ height: "100%" }}>
          <Stack spacing={2} sx={{ p: 3, pt: 0, typography: "body2", mt: 5 }}>
            <Grid container spacing={{ xs: 0.5, md: 2 }}>
              <Grid xs={12} md={4} sx={{ color: "text.secondary" }}>
                Agency Name
              </Grid>
              <Grid
                xs={12}
                md={8}
                sx={{ typography: "subtitle2", textTransform: "capitalize" }}
              >
                {agency.name || "Agency not found"}
              </Grid>
            </Grid>
            <Divider sx={{ borderStyle: "dashed" }} />

            <Grid container spacing={{ xs: 0.5, md: 2 }}>
              <Grid xs={12} md={4} sx={{ color: "text.secondary" }}>
                Agency Description
              </Grid>
              <Grid
                xs={12}
                md={8}
                sx={{ typography: "subtitle2", textTransform: "capitalize" }}
              >
                {agency.description ? (
                  <div
                    dangerouslySetInnerHTML={{ __html: agency.description }}
                  />
                ) : (
                  "No description available"
                )}
              </Grid>
            </Grid>
            <Divider sx={{ borderStyle: "dashed" }} />

            <Grid container spacing={{ xs: 0.5, md: 2 }}>
              <Grid xs={12} md={4} sx={{ color: "text.secondary" }}>
                Agency Phone Number
              </Grid>
              <Grid
                xs={12}
                md={8}
                sx={{ typography: "subtitle2", textTransform: "capitalize" }}
              >
                {agency.phoneNumber || "No phone number available"}
              </Grid>
            </Grid>
            <Divider sx={{ borderStyle: "dashed" }} />

            {/* Create Date */}
            <Grid container spacing={{ xs: 0.5, md: 2 }}>
              <Grid xs={12} md={4} sx={{ color: "text.secondary" }}>
                Create Date
              </Grid>
              <Grid
                xs={12}
                md={8}
                sx={{ typography: "subtitle2", textTransform: "capitalize" }}
              >
                <ListItemText
                  primary={
                    agency.createDate
                      ? fDate(agency.createDate)
                      : "Date not available"
                  }
                  primaryTypographyProps={{ typography: "body2" }}
                  secondaryTypographyProps={{
                    mt: 0.5,
                    component: "span",
                    typography: "caption",
                  }}
                />
              </Grid>
            </Grid>
            <Divider sx={{ borderStyle: "dashed" }} />

            <Grid container spacing={{ xs: 0.5, md: 2 }}>
              <Grid xs={12} md={4} sx={{ color: "text.secondary" }}>
                Agency Address
              </Grid>
              <Grid
                xs={12}
                md={8}
                sx={{ typography: "subtitle2", textTransform: "capitalize" }}
              >
                {agency.address
                  ? `${agency.address.primaryAddresse || ""}, ${
                      agency.address.optionalAddress || ""
                    }, ${agency.address.city || ""}, ${
                      agency.address.country || ""
                    } ${agency.address.postalCode || ""}`
                  : "No address available"}
              </Grid>
            </Grid>
          </Stack>
        </Card>
      </Grid>
    </Grid>
  );
};

export default AgencyGeneralView;
