import { paths } from "@/routes/paths";
import RouterLink from "@/routes/router-link";
import Iconify from "@/shared/components/iconify/iconify";
import {
  IAgencyTableFilters,
  IAgencyTableFilterValue,
} from "@/shared/types/agency";
import {
  IGroupeFilters,
  IGroupeFilterValue,
} from "@/shared/types/groupeAgency";
import { Button, IconButton, Tooltip } from "@mui/material";
import InputAdornment from "@mui/material/InputAdornment";
import Stack from "@mui/material/Stack";
import TextField from "@mui/material/TextField";
import { useCallback } from "react";
type Props = {
  filters: IGroupeFilters;
  onFilters: (name: string, value: IGroupeFilterValue) => void;
  agencyId: string;
};
export default function GroupeToolbar({ filters, onFilters, agencyId }: Props) {
  const handleFilterName = useCallback(
    (event: React.ChangeEvent<HTMLInputElement>) => {
      onFilters("name", event.target.value);
    },
    [onFilters]
  );

  return (
    <>
      <Stack
        spacing={2}
        alignItems={{ xs: "flex-end", md: "center" }}
        direction={{
          xs: "column",
          md: "row",
        }}
        justifyContent="space-between"
        sx={{
          p: 2.5,
          pr: { xs: 2.5, md: 1 },
        }}
      >
        <Stack
          direction="row"
          alignItems="center"
          spacing={2}
          flexGrow={1}
          sx={{ width: 1 }}
        >
          <TextField
            fullWidth
            value={filters.name}
            onChange={handleFilterName}
            placeholder="Search name group..."
            InputProps={{
              startAdornment: (
                <InputAdornment position="start">
                  <Iconify
                    icon="eva:search-fill"
                    sx={{ color: "text.disabled" }}
                  />
                </InputAdornment>
              ),
            }}
            sx={{
              width: { xs: 1, md: 260 },
            }}
          />
        </Stack>
        <Tooltip title="Add Group">
          <Button
            component={RouterLink}
            href={paths.dashboard.agency.groupe.add(agencyId)} // Use agencyId
            variant="contained"
            startIcon={<Iconify icon="mingcute:add-line" />}
          >
            New
          </Button>
        </Tooltip>
      </Stack>
    </>
  );
}
