import Chart, { useChart } from '@/shared/components/chart';

// ----------------------------------------------------------------------

type Props = {
  series: {
    name: string;
    data: number[];
  }[];
  axis: string[];
  searchValue: string;
  color: string[];
  customOptions?: any; // Ajoutez cette ligne pour accepter des options personnalisées
};

export default function ChartColumnStacked({ series, axis, searchValue, color, customOptions = {} }: Props) {
  const getChartOptions = (categories: string[]) => {
    const baseOptions = {
      chart: {
        stacked: true,
        zoom: {
          enabled: true,
        },
      },
      legend: {
        itemMargin: {
          vertical: 8,
        },
        position: 'right',
        offsetY: 20,
      },
      plotOptions: {
        bar: {
          columnWidth: '16%',
        },
      },
      stroke: {
        show: false,
      },
      xaxis: {
        categories: categories,
      },
      ...customOptions, // Fusionner les options personnalisées
    };

    return useChart(baseOptions);
  };

  if (searchValue.trim() === "") {
    const chartOptions = getChartOptions(axis);

    return (
      <Chart dir="ltr" type="bar" series={series} options={chartOptions} width="100%" height={320} />
    );
  }

  const filteredSeries = series.map((item) => {
    const filteredData = item.data.filter((dataItem, index) =>
      axis[index].toLowerCase().includes(searchValue.toLowerCase())
    );
    return {
      ...item,
      data: filteredData,
    };
  });

  const filteredAxis = axis.filter((axisItem) =>
    axisItem.toLowerCase().includes(searchValue.toLowerCase()) 
  );

  const chartOptions = getChartOptions(filteredAxis);

  return (
    <Chart dir="ltr" type="bar" series={filteredSeries} options={chartOptions} width="100%" height={320} />
  );
}