import Chart, { useChart } from '@/shared/components/chart';

// ----------------------------------------------------------------------

interface Props {
  series: {
    name: string;
    data: number[];
    axis: string[];
    color: string;
  }[];
  chartOptions?: any;
  height?: number;
}

export default function ChartLine({ series, chartOptions = {}, height = 320 }: Props) {
  const defaultOptions = {
    xaxis: {
      categories: series[0].axis,
    },
    tooltip: {
      x: {
        show: false,
      },
      marker: { show: false },
    },
  };

  const mergedOptions = useChart({
    ...defaultOptions,
    ...chartOptions,
  });

  return (
    <Chart dir="ltr" type="line" series={series} options={mergedOptions} width="100%" height={height} />
  );
}
