import Iconify from "@/shared/components/iconify";
import { Button, Dialog, DialogActions, DialogContent, DialogProps, DialogTitle, Divider, InputAdornment, TextField, Typography } from "@mui/material";
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import FormControl from '@mui/material/FormControl';
import FormLabel from '@mui/material/FormLabel';
import { useCallback, useState } from "react";
import ChatHeaderCompose from "./chat-header-compose";
import { IChatParticipant, IClient } from "@/shared/types/chat";
import { useGetContacts } from "@/shared/api/chat";

type Props = DialogProps & {
    //
    open: boolean;
    onClose: VoidFunction;
  };

export default function ChatNewChannel({open,
    onClose,...other}:Props){
    
    const [value, setValue] = useState('public');

    const [channelName, setChannelName] = useState('');

    const [descriptionChannel, setDescriptionChannel] = useState('');

    const isChannelNameEmpty = channelName.trim() === '';

    const { contacts } = useGetContacts();

    const [recipients, setRecipients] = useState<IClient[]>([]);

    const handleChannelNameChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        setChannelName(event.target.value);
    };

    const handleAddRecipients = useCallback((selected: IClient[]) => {
        setRecipients(selected);
      }, []);

    const handleChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        setValue((event.target as HTMLInputElement).value);
    };

    return (
        <Dialog fullWidth maxWidth="xs" open={open} onClose={onClose}>
        <DialogTitle> New channel </DialogTitle>

        <DialogContent sx={{ overflow: 'unset' }}>
        
            <Typography variant="body2" sx={{ color: 'text.primary', mr: 2,my: 2 }}>
                Channel name :
            </Typography>
            <TextField
                fullWidth
                label="Channel name"
                value={channelName}
                onChange={handleChannelNameChange}
                sx={{ mb: 3 }}
            />
            <Divider sx={{my:1}}/>

            <Typography variant="body2" sx={{ color: 'text.primary', mr: 2,my: 2 }}>
                Description :
            </Typography>
            <TextField
                fullWidth
                label="Channel description"
                value={descriptionChannel}
                sx={{ mb: 2 }}
            />

            <Divider sx={{my:1}}/>
            <FormControl>
                <FormLabel id="demo-controlled-radio-buttons-group" sx={{mb:2,color: 'text.primary', }} >Type</FormLabel>
                <RadioGroup
                    aria-labelledby="demo-controlled-radio-buttons-group"
                    name="controlled-radio-buttons-group"
                    value={value}
                    onChange={handleChange}
                >
                    <FormControlLabel value="public" control={<Radio />} label="Public" />
                    <FormControlLabel value="private" control={<Radio />} label="Private" />
                </RadioGroup>
            </FormControl>
            <Divider sx={{my:1}}/>
            <ChatHeaderCompose  onAddRecipients={handleAddRecipients} >
                <Typography variant="body2" sx={{ color: 'text.primary', mr: 2,my: 2 }}>
                    Members :
                </Typography>
            </ChatHeaderCompose>

        </DialogContent>

        <DialogActions sx={{ justifyContent: 'end' }}>
            <Button
                color="inherit"
                variant="contained"
                disabled={isChannelNameEmpty}
                onClick={()=>{console.log(channelName,value)}}
            >
                Create
            </Button>
            <Button variant="outlined" color="inherit" onClick={onClose}>
                Close
            </Button>

        </DialogActions>
        </Dialog>
    );
}