
'use client';

import Box from '@mui/material/Box';
import Link from '@mui/material/Link';
import Card from '@mui/material/Card';
import Stack from '@mui/material/Stack';
import Divider from '@mui/material/Divider';
import MenuItem from '@mui/material/MenuItem';
import IconButton from '@mui/material/IconButton';
import Typography from '@mui/material/Typography';
import ListItemText from '@mui/material/ListItemText';
import RouterLink from '@/routes/router-link';
import { fDate } from '@/utils/format-time';
import Iconify from '@/shared/components/iconify';
import CustomPopover, { usePopover } from '@/shared/components/custom-popover';
import { IInvoice } from '@/shared/types/invoice';
import { alpha, useTheme } from '@mui/material/styles';
import Label from '@/components/label';
import TextMaxLine from '@/components/text-max-line';





// ----------------------------------------------------------------------

type Props = {
    invoice: IInvoice;
    onView: VoidFunction;
    onEdit: VoidFunction;
    onDelete: VoidFunction;
};


export default function InvoiceItemGridView({ invoice, onView, onEdit, onDelete }: Props) {
  
    const popover = usePopover();

    const theme = useTheme();

    const { invoiceNumber, createDate, dueDate , invoiceClient, totalAmount ,status,paymentMode} =invoice;

    return (
    <>
      {/* <Card sx={{ boxShadow: `0px 2px 4px ${blue[100]}` }}> */}
        <Stack component={Card}  sx={{ boxShadow: '0px 2px 4px #89CFF3' }} >
            {/* <Stack
              sx={{
                p: (theme) => theme.spacing(3, 3, 2, 3),
              }}
            > */}
                {/* <Stack direction="row" alignItems="center" justifyContent="space-between" sx={{ mb: 2 }}> */}
                    <IconButton onClick={popover.onOpen} sx={{ position: 'absolute', top: 8, right: 4 }}>
                      <Iconify icon="eva:more-vertical-fill" />
                    </IconButton>
                    <ListItemText
                      sx={{ mb: 1, mt: 2, ml: 2 }}
                      primary={
                        <Stack direction="row" alignItems="center" justifyContent="space-between" sx={{ mb: 2,mr:8 }}>
                        <Link component={RouterLink} href={"/"} color="inherit">
                          {invoiceNumber}
                        </Link>

                        <Label variant="soft" color={(status === 'paid' && 'success' || status === 'pending' && 'warning' || status === 'overdue' && 'error'|| status === 'draft' && 'info') || 'default'}>
                              {status}
                        </Label>
                        </Stack>
                      }


                      primaryTypographyProps={{
                        typography: 'subtitle1',
                      }}

                    />

                    <Divider sx={{ borderStyle: 'dashed' }} />

                    <Stack sx={{ p: 3, pb: 2 }}>

                    <Box columnGap={1} display="grid" gridTemplateColumns="repeat(2, 1fr)" >


                        <Box rowGap={1} display="grid" gridTemplateColumns="repeat(1, 2fr)" >
                          <Stack
                            spacing={0.5}
                            direction="row"
                            alignItems="center"
                            sx={{ color: 'black', typography: 'caption' }}
                          >
                            <Iconify width={16} icon="tabler:calendar-due" />
                            {fDate(createDate)}
                          </Stack>
                          <Stack
                            spacing={0.5}
                            direction="row"
                            alignItems="center"
                            sx={{ color: 'red', typography: 'caption' }}
                          >
                            <Iconify width={16} icon="mdi:bell" />
                            {fDate(dueDate)}
                          </Stack>
                        </Box>

                        <Stack direction="column" alignItems="center" justifyContent="space-between" sx={{ mb: 2 }} marginLeft="20px">
                            {/* <TextMaxLine variant="subtitle2" line={2}>
                              {paymentMode}
                            </TextMaxLine> */}
                        </Stack>

                    </Box>
                    </Stack>

                    <Divider sx={{ borderStyle: 'dashed' }} />

                    <Box rowGap={1.5} display="grid" gridTemplateColumns="repeat(2, 1fr)" sx={{ p: 3 }}>
                      {[
                        {
                          label: invoiceClient.company,
                          icon: <Iconify width={16} icon="solar:users-group-rounded-bold" sx={{ flexShrink: 0 }} />,
                        },
                        {
                          label: totalAmount,
                          icon: <Iconify width={16} icon="solar:chat-round-money-line-duotone" sx={{ flexShrink: 0 }} />,
                        },

                      ].map((item) => (
                        <Stack
                          key={item.label}
                          spacing={0.5}
                          flexShrink={0}
                          direction="row"
                          alignItems="center"
                          sx={{ color: 'text.disabled', minWidth: 0 }}
                        >
                          {item.icon}
                          <Typography variant="caption" noWrap>
                            {item.label}
                          </Typography>
                        </Stack>
                      ))}
                   </Box>
                {/* </Stack>    
            </Stack> */}
        </Stack>
        {/* </Card> */}
  
      <CustomPopover
        open={popover.open}
        onClose={popover.onClose}
        arrow="right-top"
        sx={{ width: 140 }}
      >
        <MenuItem
          onClick={() => {
            popover.onClose();
            onView();
          }}
        >
          <Iconify icon="solar:eye-bold" />
          View
        </MenuItem>

        <MenuItem
          onClick={() => {
            popover.onClose();
            onEdit();
          }}
        >
          <Iconify icon="solar:pen-bold" />
          Edit
        </MenuItem>

        <MenuItem
          onClick={() => {
            popover.onClose();
            onDelete();
          }}
          sx={{ color: 'error.main' }}
        >
          <Iconify icon="solar:trash-bin-trash-bold" />
          Delete
        </MenuItem>
      </CustomPopover>
    </>
  );
}
