import Iconify from "@/shared/components/iconify";
import { ITransferTableFilters, ITransferTableFilterValue } from "@/shared/types/transfer";
import { InputAdornment, Stack, TextField } from "@mui/material";
import { useCallback } from "react";

type Props = {
    filters: ITransferTableFilters;
    onFilters: (title: string, value: ITransferTableFilterValue) => void;
};

export default function TransferTableToolbar({ filters, onFilters }: Props) {
    const handleFilterName = useCallback(
        (event: React.ChangeEvent<HTMLInputElement>) => {
            onFilters('title', event.target.value);
        },
        [onFilters]
    );

    return (
        <Stack
            spacing={2}
            alignItems={{ xs: 'flex-end', md: 'center' }}
            direction={{ xs: 'column', md: 'row' }}
            sx={{
                p: 2.5,
                pr: { xs: 2.5, md: 1 },
            }}
        >
            <TextField
                fullWidth
                value={filters.title}
                onChange={handleFilterName}
                placeholder="Search.."
                InputProps={{
                    startAdornment: (
                        <InputAdornment position="start">
                            <Iconify 
                                icon="eva:search-fill" 
                                sx={{ 
                                    color: 'text.disabled',
                                    width: 20,
                                    height: 20,
                                }} 
                            />
                        </InputAdornment>
                    ),
                }}
                sx={{
                    width: { xs: 1, md: 280 },
                    '& .MuiOutlinedInput-root': {
                        '& fieldset': {
                            borderColor: (theme) => theme.palette.divider,
                        },
                        '&:hover fieldset': {
                            borderColor: 'primary.main',
                        },
                    },
                }}
            />
        </Stack>
    );
}