/** @type {import('next').NextConfig} */
const nextConfig = {
    webpack: (config, options) => {
        // Règle pour les fichiers PDF
        config.module.rules.push({
            test: /\.(pdf)$/,
            use: [
                {
                    loader: 'file-loader',
                    options: {
                        publicPath: '/_next',
                        name: 'static/media/[name].[hash].[ext]',
                    },
                },
            ],
        });
        return config;
    },
};

export default nextConfig;
