'use client'

import { paths } from "@/routes/paths";
import CustomBreadcrumbs from "@/shared/components/custom-breadcrumbs";
import { useSettingsContext } from "@/shared/components/settings";
import { Container } from "@mui/material";
import UserAgencyForm from "@/shared/sections/agency/user-agency-form";


  export default function CreateAgency() {
    const settings = useSettingsContext();
  
  
    return (
      <Container maxWidth={settings.themeStretch ? false : 'lg'}>
        <CustomBreadcrumbs
          heading="Create"
          links={[
            {
              name: 'Dashboard',
              href: paths.dashboard.root,
            },
            {
              name: 'User Agency',
              href: paths.dashboard.agency.list,
            },
            {name : 'New User agency'},
           
          ]}
          sx={{
            mb: { xs: 3, md: 5 },
          }}
        />
  
        <UserAgencyForm />
      </Container>
    );
  }
  