'use client';

import { AuthGuard } from '@/contexts/auth/guard';
import DashboardLayout from '@/shared/layouts/dashboard';
import { LocalizationProvider } from '@mui/x-date-pickers';
import Chat from '@marketingconfort/mc-chat-front';

// ----------------------------------------------------------------------

type Props = {
  children: React.ReactNode;
};

const customTheme = {
  colors: {
    primary: '#f4f6f8',     
    secondary: '#08a46c',   
    background: '#F4F6F9',  
    font: '#212529'        
  }
};

const envUrls = {
  hostApi: process.env.NEXT_PUBLIC_CHAT_HOST_API || '',
  chatWs: process.env.NEXT_PUBLIC_CHAT_WS || '',
  awsBucket: process.env.NEXT_PUBLIC_AWS_BUCKET || '',
  clientUserServiceUrl: process.env.NEXT_PUBLIC_CLIENT_USER_SERVICE_URL || '',
};

export default function Layout({ children }: Props) {
  return (
    <AuthGuard>
      <LocalizationProvider>
      <DashboardLayout>{children}</DashboardLayout>
      <Chat theme={customTheme} envUrls={envUrls} />
      </LocalizationProvider>
    </AuthGuard>
  );
}
