import { _mock } from './_mock';
import { _tags } from './assets';
import { IPdf } from '@/shared/types/file';

// ----------------------------------------------------------------------

const GB = 1000000000 * 24;

const FOLDERS = ['Marketing', 'Stunar project', 'Mydressin project', 'AppChat', 'Adanev', 'Shared files'];
const pdf: IPdf = {
  name: 'Services_marketing_confort',
  url: '../../../public/assets/testPlayers/Services_marketing_confort.pdf'
};

const FILES = [
  'cover-2.jpg',
  'design-suriname-2015.mp3',
  'expertise-2015-conakry-sao-tome-and-principe-gender.mp4',
  'money-popup-crack.pdf',
  'cover-4.jpg',
  'cover-6.jpg',
  'large-news.txt',
  'nauru-6015-small-fighter-left-gender.psd',
  'tv-xs.doc',
  'gustavia-entertainment-productivity.docx',
  'vintage-bahrain-saipan.xls',
  'indonesia-quito-nancy-grace-left-glad.xlsx',
  'legislation-grain.zip',
  'large-energy-dry-philippines.rar',
  'footer-243-ecuador.iso',
  'kyrgyzstan-04795009-picabo-street-guide-style.ai',
  'india-data-large-gk-chesterton-mother.esp',
  'footer-barbados-celine-dion.ppt',
  'socio-respectively-366996.pptx',
  'socio-ahead-531437-sweden-popup.wav',
  'trinidad-samuel-morse-bring.m4v',
  'cover-12.jpg',
  'cover-18.jpg',
  'xl-david-blaine-component-tanzania-books.pdf',
];

const URLS = [
  _mock.image.cover(1),
  'https://media.w3.org/2010/05/sintel/trailer_hd.mp4',
  'https://media.w3.org/2010/05/sintel/trailer_hd.mp4',
   pdf.url,
  _mock.image.cover(3),
  _mock.image.cover(5),
  'https://www.cloud.com/s/c218bo6kjuqyv66/large_news.txt',
  'https://www.cloud.com/s/c218bo6kjuqyv66/nauru-6015-small-fighter-left-gender.psd',
  'https://www.cloud.com/s/c218bo6kjuqyv66/tv-xs.doc',
  'https://calibre-ebook.com/downloads/demos/demo.docx',
  'https://fichier-xls.com/2017/10/21/test/',
  'https://www.coursinfo.fr/wp-content/uploads/2016/10/TP_Excel-avec-correction.xlsx',
  'https://www.cloud.com/s/c218bo6kjuqyv66/legislation-grain.zip',
  'https://www.cloud.com/s/c218bo6kjuqyv66/large_energy_dry_philippines.rar',
  'https://www.cloud.com/s/c218bo6kjuqyv66/footer-243-ecuador.iso',
  'https://www.cloud.com/s/c218bo6kjuqyv66/kyrgyzstan-04795009-picabo-street-guide-style.ai',
  'https://www.cloud.com/s/c218bo6kjuqyv66/india-data-large-gk-chesterton-mother.esp',
  'https://public.iutenligne.net/marketing-mercatique/lacoeuilhe/MKG_fondamental_chapitre1.ppt',
  'https://www.cloud.com/s/c218bo6kjuqyv66/socio_respectively_366996.pptx',
  'https://media.w3.org/2010/05/sintel/trailer_hd.mp4',
  'https://www.cloud.com/s/c218bo6kjuqyv66/trinidad_samuel-morse_bring.m4v',
  _mock.image.cover(11),
  _mock.image.cover(17),
  "https://www.w3.org/WAI/ER/tests/xhtml/testfiles/resources/pdf/dummy.pdf"
];

const Owners = [
  'Mohssine Bahhou',
  'Khouili khadija',
  'Ahlame Elbahri',
  'Safae Ettajrini',
  'Youssra Baddo',
  'Fatima Haddioui'
];


const owner = (sharedPersons: User[]) => {
  const randomIndex = Math.floor(Math.random() * sharedPersons.length);
  return sharedPersons[randomIndex];
};
const SHARED_PERSONS = [...Array(20)].map((_, index) => ({
  id: _mock.id(index),
  name: _mock.fullName(index),
  email: _mock.email(index),
  avatarUrl: _mock.image.avatar(index),
  permission: index % 2 ? 'view' : 'edit',
}));

export const FILE_TYPE_OPTIONS = [
  'folder',
  'txt',
  'zip',
  'audio',
  'image',
  'video',
  'word',
  'excel',
  'powerpoint',
  'pdf',
  'photoshop',
  'illustrator',
];

// ----------------------------------------------------------------------

const shared = (index: number) =>
  (index === 0 && SHARED_PERSONS.slice(0, 5)) ||
  (index === 1 && SHARED_PERSONS.slice(5, 9)) ||
  (index === 2 && SHARED_PERSONS.slice(9, 11)) ||
  (index === 3 && SHARED_PERSONS.slice(11, 12)) ||
  [];


export const _folders = FOLDERS.map((name, index) => ({
  id: `${_mock.id(index)}_folder`,
  name,
  type: 'folder',
  url: URLS[index],
  Proprietaire: owner(SHARED_PERSONS),
  shared: shared(index),
  tags: _tags.slice(0, 5),
  size: GB / ((index + 1) * 10),
  totalFiles: (index + 1) * 100,
  createdAt: _mock.time(index),
  modifiedAt: _mock.time(index),
  isFavorited: _mock.boolean(index + 1),
}));

export const _files = FILES.map((name, index) => ({
  id: `${_mock.id(index)}_file`,
  name,
  url: URLS[index],
  Proprietaire: owner(SHARED_PERSONS),
  shared: shared(index),
  tags: _tags.slice(0, 5),
  size: GB / ((index + 1) * 500),
  createdAt: _mock.time(index),
  modifiedAt: _mock.time(index),
  type: `${name.split('.').pop()}`,
  isFavorited: _mock.boolean(index + 1),
}));

export const _allFiles = [..._folders, ..._files];

type User = {
  id: string;
  name: string;
  email: string;
  avatarUrl: string;
  permission: string;
};
