import { add,subDays } from 'date-fns';
import { _mock } from './_mock';
import { ITaskItem } from '@/contexts/types/tasks';

                  
//----------------------------------
  export const TASK_TYPE_OPTIONS = [
    { value: 'BUG', label: 'bug' },
    { value: 'FEATURE', label: 'feature' }
  ];

  export const TASK_STATUS_OPTIONS = [
    { value: 'TO DO', label: 'To Do' },
  { value: 'IN PROGRESS', label: 'In Progress' },
    { value: 'VALIDATION', label: 'Validation' },
    { value: 'DONE', label: 'Done' },
  ];
  export const TASK_SORT_OPTIONS = [
    { value: 'latest', label: 'Latest' },
    { value: 'popular', label: 'Popular' },
    { value: 'oldest', label: 'Oldest' },
  ];
   
  export const _observers = [...Array(3)].map((_, index) => ({
    id: _mock.id(index),
    name: _mock.fullName(index),
    avatarUrl: _mock.image.avatar(index),
    phoneNumber: _mock.phoneNumber(index),
  }));

  export const _collaborators = [...Array(12)].map((_, index) => ({
    id: index,
    name: _mock.fullName(index),
    avatarUrl: _mock.image.avatar(index),
    phoneNumber: _mock.phoneNumber(index),
  }));
  //-----------------------------------------------------------
  export const SHARED_PERSONS = [...Array(20)].map((_, index) => ({
    id: _mock.id(index),
    name: _mock.fullName(index),
    email: _mock.email(index),
    avatarUrl: _mock.image.avatar(index),
    permission: index % 2 ? 'view' : 'edit',
  }));
 
  //-----------------------------------------------------------
  const TASKS_Deleted = [
    {
      title: 'Tâche A',
      type: TASK_TYPE_OPTIONS[0].value, 
      status: TASK_STATUS_OPTIONS[0].value, 
      note:1
    
    },
    {
      title: 'Tâche B',
      type: TASK_TYPE_OPTIONS[1].value, 
     
      status: TASK_STATUS_OPTIONS[3].value, 
      note:4
    },
    {
      title: 'Tâche C',
      type: TASK_TYPE_OPTIONS[1].value, 
     
      status: TASK_STATUS_OPTIONS[3].value, 
      note:4
    },
    {
      title: 'Tâche D',
      type: TASK_TYPE_OPTIONS[0].value, 
     
      status: TASK_STATUS_OPTIONS[0].value, 
      note:4
    },
  ];




  const TASKS = [
    {
      title: 'Tâche Alpha',
      type: TASK_TYPE_OPTIONS[0].value, 
      status: TASK_STATUS_OPTIONS[0].value, 
      note:1
    
    },
    {
      title: 'Tâche Beta',
      type: TASK_TYPE_OPTIONS[1].value, 
     
      status: TASK_STATUS_OPTIONS[1].value, 
      note:4
    },
    {
      title: 'Tâche Gamma',
      type: TASK_TYPE_OPTIONS[0].value, 
    
      status: TASK_STATUS_OPTIONS[2].value, 
    
    },
 
    {
        title: 'Task Delta',
        type: TASK_TYPE_OPTIONS[1].value, 
        
        status: TASK_STATUS_OPTIONS[0].value, 
        note:3
      },
      {
        title: 'Tâche Epsilon',
        type: TASK_TYPE_OPTIONS[0].value, 
       
        status: TASK_STATUS_OPTIONS[3].value, 
        note:2
      },
      {
        title: 'Task Zeta',
        type: TASK_TYPE_OPTIONS[1].value, 
        
        status: TASK_STATUS_OPTIONS[1].value, 
       
      },
      {
        title: 'Tâche Eta',
        type: TASK_TYPE_OPTIONS[0].value, 
       
        status: TASK_STATUS_OPTIONS[2].value, 
        note:9
      },
   
    
    
  ];
 
  
  
  export const _managers = [...Array(12)].map((_, index) => ({
    id: index,
    name: _mock.fullName(index),
    avatarUrl: _mock.image.avatar(index),
    user: {
      id: index,
      firstName: _mock.firstName(index),
      lastName: _mock.lastName(index),
      email: _mock.email(index),
    },
  }));
  
  export const _taskHistory = [...Array(5)].map((_, index) => {
    const title = [
      "Youssra Badda a créé le Ticket",
      'Youssra Badda a modifié l état',
      'el bahry ahlame a mis à jour le Rank',
      'safae ettajrini a mis à jour le Résolution',
      'safae ettajrini a créé le Ticket',
    ][index];
  
    return {
      id: _mock.id(index),
      title,
      type: `order${index + 1}`,
      time: _mock.time(index),
    };
  });

  export const _Deletedtasks =  TASKS_Deleted.map((task, index) => ({
    id: _mock.id(index),
    name: task.title,
    startDate: _mock.time(index),
    endDate: _mock.time(index),
    deleteDate: _mock.time(index),
    status: task.status,
    type: TASKS_Deleted[index].type,
    manager: _managers[index % _managers.length],
    
    // ------------------------------------------
    priority: undefined,
    attachments: undefined,
    collaborator: undefined,
    project: undefined,
    description: undefined,
    note:TASKS[index].note,
  } as unknown as ITaskItem));

  export const _tasks =  TASKS.map((task, index) => ({
    id: index,
    name: task.title,
    startDate: _mock.time(index),
    endDate: _mock.time(index),
    status: task.status,
    type: TASKS[index].type,
    manager: _managers[index % _managers.length],
    
    // ------------------------------------------
    priority: undefined,
    attachments: undefined,
    collaborator: undefined,
    project: undefined,
    description: undefined,
    note:TASKS[index].note,
  } as unknown as ITaskItem));
