import { generateToken } from "@/utils/firebase";

import { INotif } from "../types/notif";
import axiosInstance, { endpoints } from "@/utils/axios";
import { mutate } from "swr";
const NOTIFICATIONS_KEY = '/api/notifications';

export const sendNotificationToUserAfterInvoiceCreation = async (createInvoiceNotifRequest: INotif) => {
  try {
    const token = await generateToken();
    if (token) {
      const response = await axiosInstance.post(
        endpoints.notification.startInvoiceNotification(),
        {
          firebaseToken: createInvoiceNotifRequest.firebaseToken,
          email: createInvoiceNotifRequest.email
        }
      );
      
      
      await mutate(NOTIFICATIONS_KEY);
      
      return response;
    }
  } catch (error) {
    console.error("Error sending notification:", error);
    throw error;
  }
};

  export const getNotifications = async () => {
    try {
      const response = await axiosInstance.get(
        endpoints.notification.getNotifications()
      );

      if (!response || !response.data) {
        throw new Error(" invalid response server");
      }

      return response.data;
    } catch (error) {
      console.error("Error fetching notifications:", error);
      throw error;
    }
};
export const getNotificationsByEmail = async () => {
  try {
    const userEmail = localStorage.getItem('email');
    
    if (!userEmail) {
      throw new Error("Email not found in localStorage");
    }

    const response = await axiosInstance.get(
      endpoints.notification.getNotificationsByEmail(userEmail)
    );

    if (!response || !response.data) {
      throw new Error("Invalid response from server");
    }

    return response.data;
  } catch (error) {
    console.error("Error fetching notifications by email:", error);
    throw error;
  }
};


export const sendNotificationToUserAfterAssigningTask = async (assigningTaskNotifRequest: INotif) => {
  try {
    console.log('Calling notification API with:', assigningTaskNotifRequest); // Debug log
    const response = await axiosInstance.post(
      endpoints.notification.assignTaskNotification(),
      assigningTaskNotifRequest,
      {
        headers: {
          'Content-Type': 'application/json',
        }
      }
    );
    console.log('Notification API response:', response); // Debug log
    return response;
  } catch (error) {
    console.error("Error sending task assignment notification:", error);
    throw error;
  }
};

export const sendNotificationToUserAfterChangingTaskStatus = async (statusUpdateNotifRequest: INotif) => {
  try {
    const token = await generateToken();
    if (token) {
      const response = await axiosInstance.post(
        endpoints.notification.changeTaskStatusNotification(),
        statusUpdateNotifRequest
      );
      return response;
    }
  } catch (error) {
    console.error("Error sending status update notification:", error);
    throw error;
  }
};

export const sendNotificationToUserAfterComment = async (commentNotifRequest: INotif) => {
  try {
    const token = await generateToken();
    if (token) {
      const response = await axiosInstance.post(
        endpoints.notification.commentNotification(),
        commentNotifRequest
      );
      return response;
    }
  } catch (error) {
    console.error("Error sending comment notification:", error);
    throw error;
  }
};

  


