

import { useState} from 'react';

import Dialog from '@mui/material/Dialog';
import CloseIcon from '@mui/icons-material/Close';
import { IconButton } from '@mui/material';

// ----------------------------------------------------------------------

type Props = {
  open: boolean;
  onClose: VoidFunction;
  type:string;
  url:string |undefined;
  title?: string;
}

const EXTENSIONS_IMAGES=['bmp','gif','jpg','jpeg','png','tiff', 'IMAGE'];

export default function ImagePlayer({
  title,
  type,
  url,
  open,
  onClose,
  
 
}: Props) {


  const [zoomed,setZoomed]= useState(false);


  return (
    <>
      <Dialog fullWidth maxWidth="sm" open={open} onClose={onClose} PaperProps={{ sx: { backgroundColor: 'transparent' , boxShadow: 'none',
          overflow: 'hidden'} }}>
        { EXTENSIONS_IMAGES.includes(type) && zoomed?
        (
          <div
              style={{
                  position: 'fixed',
                  top: '0',
                  left: '0',
                  width: '100%',
                  height: '100%',
                  backgroundColor: 'transparent',
                  zIndex: '9999',
                  display: 'flex',
                  justifyContent: 'center',
                  alignItems: 'center',
              }}
              onClick={() => setZoomed(false)}
          > 
              <IconButton
                  sx={{ position: 'absolute', top: 8, right: 8, color: 'white', zIndex: 1 }}
                  onClick={onClose}
                  aria-label="close"
              >
                  <CloseIcon />
              </IconButton>
              <img src={url} alt={title} style={{ maxWidth: '90%', maxHeight: '90%', cursor: 'pointer' }} />
          </div>
        ):<></>}
        { EXTENSIONS_IMAGES.includes(type) && !zoomed?
        (
          <div style={{ position: 'relative' }}>
              <img src={url} alt={title} style={{ width: '100%', height: 'auto', cursor: 'pointer' }} onClick={() => setZoomed(!zoomed)} />
              <IconButton
                sx={{ position: 'absolute', top: 8, right: 8, color: 'white', zIndex: 1 }}
                onClick={onClose}
                aria-label="close"
              >
                <CloseIcon />
              </IconButton>
          </div>
        )
        :<></>
        }
     </Dialog>
    </>
  );
}

