import Stack from '@mui/material/Stack';
import AppBar from '@mui/material/AppBar';
import Toolbar from '@mui/material/Toolbar';
import { useTheme } from '@mui/material/styles';
import IconButton from '@mui/material/IconButton';

import { useOffSetTop } from '@/hooks';
import { useResponsive } from '@/hooks';

import { bgBlur } from '@/shared/theme/css';

import Logo from '@/shared/components/logo';
import SvgColor from '@/shared/components/svg-color';
import { useSettingsContext } from '@/shared/components/settings';
import { usePathname } from 'next/navigation';
import Searchbar from '../common/searchbar';
import { NAV, HEADER } from '../config-layout';
import SettingsButton from '../common/settings-button';
import AccountPopover from '../common/account-popover';
import ContactsPopover from '../common/contacts-popover';
import LanguagePopover from '../common/language-popover';
import NotificationsPopover from '../common/notifications-popover';
import { NavSectionHorizontal } from '@/shared/components/nav-section';
import { useNavData } from './config-navigation';
import NavHorizontal from './nav-horizontal';
import { alpha, Box, Button, Typography } from '@mui/material';
import Iconify from '@/shared/components/iconify';
import { useState } from 'react';

// ----------------------------------------------------------------------

type Props = {
  onOpenNav?: VoidFunction;
};

export default function Header({ onOpenNav }: Props) {
  const theme = useTheme();
  const settings = useSettingsContext();
  const lgUp = useResponsive('up', 'lg');
  const isNavHorizontal = settings.themeLayout === 'horizontal';
  const isNavMini = settings.themeLayout === 'mini';
  const navData = useNavData();
  const pathname = usePathname(); 
  const [showBanner, setShowBanner] = useState(true);
  const renderContent = (
    <>
      <Stack 
        direction="row" 
        alignItems="center" 
        spacing={2} 
        sx={{ 
          flexGrow: 0,
          minWidth: isNavHorizontal ? 'auto' : NAV.W_VERTICAL,
          
          display: { 
            xs: 'flex',
            lg: isNavHorizontal ? 'flex' : 'none' 
          }
        }}
      >
        <Logo sx={{ mr: 2.5 }} />
        
        {lgUp ? null : (
  <IconButton 
    onClick={onOpenNav}
    sx={{
      mr: 1,
      color: 'text.primary',
      display: { lg: 'none' }
    }}
  >
    <SvgColor src="/assets/icons/navbar/ic_menu_item.svg" />
  </IconButton>
)}
      </Stack>
      {isNavHorizontal && lgUp ? (
        <Stack
          direction="row"
          alignItems="center"
          sx={{
            flexGrow: 1,
            justifyContent: 'center',
            height: 1,
          }}
        >
         <NavSectionHorizontal
        data={navData}
        slotProps={{  
          currentPath: pathname,
           
        }}
        sx={{
          ...theme.mixins.toolbar,
          '& .MuiListItemButton-root': {
            minHeight: 44,
            padding: '8px 12px',
            marginRight: 1,
            borderRadius: 1,
            border: '1px solid transparent',
            '&:hover': {
              backgroundColor: alpha('#144dd5', 0.08),
              color: '#144dd5',
              borderColor: alpha('#144dd5', 0.24),
              '& .MuiListItemIcon-root': {
                color: '#144dd5',
              },
            },
          },
          '& .MuiListItemButton-root.active': {
            backgroundColor: alpha('#144dd5', 0.08),
            border: `1px solid ${alpha('#144dd5', 0.24)}`,
            borderRadius: 1,
            color: '#144dd5',
            fontWeight: 'bold',
            '&:hover': {
              backgroundColor: alpha('#144dd5', 0.16),
              borderColor: alpha('#144dd5', 0.32),
            },
            '& .MuiListItemIcon-root': {
              color: '#144dd5',
            },
          },
          '& .MuiTypography-root': {
            fontWeight: 'medium',
          },
          '& .active .MuiTypography-root': {
            fontWeight: 'bold',
          },
        }}
      />
        </Stack>
      ) : (
        <Box sx={{ flexGrow: 1 }} />
      )}

      <Stack
        direction="row"
        alignItems="center"
        spacing={1}
        sx={{ 
          flexGrow: 0,
          height: 1,
        }}
      >
        <Searchbar />
        <NotificationsPopover />
        {/* <ContactsPopover /> */}
        {/* <SettingsButton /> */}
        <AccountPopover />
      </Stack>
    </>
  );

  return (
    <>
    {showBanner && (
    <Box
        sx={{
          width: '100%',
          height: 40,
          display: 'flex',
          alignItems: 'center',
          justifyContent: 'center',
          background: 'linear-gradient(90deg, #E6E6FA 0%, #E0FFFF 100%)',
          position: 'fixed',
          top: 0,
          zIndex: theme.zIndex.appBar + 2,
        }}
      >
        <Typography variant="h6" sx={{ mr: 2,fontSize: '0.80rem', 
        fontWeight: 400 }}>
          Welcome to Stunar! Book Your Onboarding Call
        </Typography>
        <Button
          variant="contained"
          size="small"
          sx={{
            backgroundColor: '#144dd5',
            '&:hover': {
              backgroundColor: '#144dd5',
            },
            borderRadius: 20,
            textTransform: 'none',
            px: 2,
          }}
        >
          Book Your Call
        </Button>
        
        <IconButton
        onClick={() => setShowBanner(false)}
          sx={{
            position: 'absolute',
            right: 10,
            color: 'text.secondary',
          }}
        >
          <Iconify icon="eva:close-fill" />
        </IconButton>
      </Box>
      )}
    <AppBar
     sx={{
      height: HEADER.H_MOBILE,
      zIndex: theme.zIndex.appBar + 1,
      backgroundColor: 'background.paper',
      marginTop: showBanner ? '40px' : 0,
      ...bgBlur({
        color: theme.palette.background.default,
      }),
      '& .MuiListItemButton-root.active': {
        backgroundColor: alpha('#144dd5', 0.08),
        border: `1px solid ${alpha('#144dd5', 0.24)}`,
        borderRadius: 1,
        color: 'primary.main',
        '&:hover': {
          backgroundColor: alpha('#144dd5', 0.16),
        },
        '& .MuiListItemIcon-root': {
          color: '#144dd5',
        },
      },
      '& .MuiListItemButton-root': {
        borderRadius: 1,
        border: '1px solid transparent',
        '&:hover': {
          backgroundColor: alpha('#144dd5', 0.08),
          color: '#144dd5',
          '& .MuiListItemIcon-root': {
            color: '#144dd5',
          },
        },
      },
      
  
        transition: theme.transitions.create(['height', 'width'], {
          duration: theme.transitions.duration.shorter,
        }),
        ...(lgUp && {
          width: isNavHorizontal 
            ? '100%' 
            : `calc(100% - ${isNavMini ? NAV.W_MINI : NAV.W_VERTICAL}px)`,
          height: HEADER.H_DESKTOP,
          ...(isNavHorizontal && {
            bgcolor: 'background.paper',
        
          }),
        }),
      }}
    >
      <Toolbar
        sx={{
          height: 1,
          px: { lg: 5 },
          display: 'flex',
          alignItems: 'center',
          justifyContent: 'space-between',
        }}
      >
        {renderContent}
      </Toolbar>
    </AppBar>
    </>
  );
}