import Button from "@mui/material/Button";
import Avatar from "@mui/material/Avatar";
import Divider from "@mui/material/Divider";
import MenuItem from "@mui/material/MenuItem";
import TableRow from "@mui/material/TableRow";
import Checkbox from "@mui/material/Checkbox";
import TableCell from "@mui/material/TableCell";
import IconButton from "@mui/material/IconButton";
import Typography from "@mui/material/Typography";
import ListItemText from "@mui/material/ListItemText";

import { useBoolean } from "@/hooks";
import { fDate, fTime } from "@/utils/format-time";

import Label from "@/shared/components/label";
import Iconify from "@/shared/components/iconify";
import { ConfirmDialog } from "@/shared/components/custom-dialog";
import CustomPopover, { usePopover } from "@/shared/components/custom-popover";
import { collaborator, IManager, ITaskItem } from "@/contexts/types/tasks";
import { _managers, _tasks } from "@/shared/_mock";

import KanbanDetails from "../details-task/task-details";
import { AvatarGroup, Box, Stack, avatarGroupClasses } from "@mui/material";
import { useGetManager } from "@/shared/api/task";
import { useEffect, useState } from "react";
// ----------------------------------------------------------------------

type Props = {
  row: ITaskItem;
  selected: boolean;
  selectedTask: ITaskItem | null;
  onSelectRow: VoidFunction;
  onViewRow: VoidFunction;
  onDeleteRow: VoidFunction;
};

export default function TaskDeletedTableRow({
  row,
  selected,
  onSelectRow,
  selectedTask,
  onViewRow,
  onDeleteRow,
}: Props) {
  const { name, managerId, startDate, endDate, column, type, deletedAt } = row;
  const confirm = useBoolean();
  const popover = usePopover();
  const openDetails = useBoolean();
  const validManagerId = managerId ?? 0;
  const {
    managerData: manager,
    managerIsLoading,
    managerError,
  } = useGetManager(validManagerId);

  const [managerData, setManagerData] = useState<collaborator>(manager);
  useEffect(() => {
    if (manager) {
      setManagerData(manager);
    }
  }, [manager]);

  return (
    <>
      <TableRow
        hover
        selected={selected}
        onClick={() => {
          onViewRow();
          openDetails.onTrue();
          popover.onClose();
        }}
      >
        <TableCell sx={{ display: "flex", alignItems: "center" }}>
          <ListItemText
            disableTypography
            primary={
              <Typography variant="body2" noWrap>
                {name}
              </Typography>
            }
          />
        </TableCell>

        <TableCell>
          <ListItemText
            primary={fDate(startDate)}
            secondary={fTime(startDate)}
            primaryTypographyProps={{ typography: "body2", noWrap: true }}
            secondaryTypographyProps={{
              mt: 0.5,
              component: "span",
              typography: "caption",
            }}
          />
        </TableCell>

        <TableCell>
          <ListItemText
            primary={fDate(endDate)}
            secondary={fTime(endDate)}
            primaryTypographyProps={{ typography: "body2", noWrap: true }}
            secondaryTypographyProps={{
              mt: 0.5,
              component: "span",
              typography: "caption",
            }}
          />
        </TableCell>

        <TableCell>{type}</TableCell>

        <TableCell sx={{ display: "flex", alignItems: "center" }}>
          {managerData ? (
            <>
              <Avatar
                alt={
                  managerData.user.lastName + " " + managerData.user.firstName
                }
                sx={{ width: 40, height: 40, flexShrink: 0, marginRight: 1 }}
              >
                {managerData.user.firstName.charAt(0).toUpperCase() +
                  managerData.user.lastName.charAt(0).toUpperCase()}
              </Avatar>

              <ListItemText
                disableTypography
                primary={
                  <Typography variant="body2" noWrap>
                    {" " +
                      managerData.user.firstName +
                      " " +
                      managerData.user.lastName}
                  </Typography>
                }
              />
            </>
          ) : (
            <Typography variant="body2" noWrap>
              Manager not found
            </Typography>
          )}
        </TableCell>
        <TableCell>
          <Label
            variant="soft"
            color={
              (column.name === "done" && "success") ||
              (column.name === "in progress" && "warning") ||
              (column.name === "to do" && "error") ||
              "default"
            }
          >
            {column.name}
          </Label>
        </TableCell>
        <TableCell>
          <ListItemText
            primary={fDate(deletedAt)}
            secondary={fTime(deletedAt)}
            primaryTypographyProps={{ typography: "body2", noWrap: true }}
            secondaryTypographyProps={{
              mt: 0.5,
              component: "span",
              typography: "caption",
            }}
          />
        </TableCell>
      </TableRow>
    </>
  );
}
