import { formatDistanceToNowStrict } from 'date-fns';

import Box from '@mui/material/Box';
import Stack from '@mui/material/Stack';
import Avatar from '@mui/material/Avatar';
import IconButton from '@mui/material/IconButton';
import Typography from '@mui/material/Typography';

import { useMockedUser } from '@/hooks/use-mocked-user';

import Iconify from '@/shared/components/iconify';

import { IChatMessage,IClient } from '@/shared/types/chat';
import { alpha } from '@mui/material/styles';


import { useGetMessage } from '@/hooks';
import { useState } from 'react';


// ----------------------------------------------------------------------

type Props = {
  message: IChatMessage ;
  participants: IClient[];
  onOpenLightbox: (value: string) => void;
  onClick?: (messageId: string) => void;
  // children: React.ReactNode;
  onCloseReply?: () => void;
};

export default function ChatReplyMessage({ message, participants, onOpenLightbox,onCloseReply ,onClick}: Props) {

  const { user1 } = useMockedUser();

  const { me, senderDetails, hasImage } = useGetMessage({
    message,
    participants,
    currentUserId: `${user1?.id}`,
  });

  const { firstName, avatarUrl } = senderDetails;

  const { body, createdAt } = message;

  const [anchorEl, setAnchorEl] = useState<null | HTMLElement>(null);

  const handleChipClick = (event: React.MouseEvent<HTMLElement>) => {
    setAnchorEl(event.currentTarget);
  };

  const handleClose = () => {
    setAnchorEl(null);
  };

  const open = Boolean(anchorEl);
  const id = open ? 'simple-popover' : undefined;  

  const renderInfo = (
    <Typography
      noWrap
      variant="caption"
      sx={{
        color: 'grey.700',
        ml:2
      }}
    >
      <strong>{!me ? `${firstName} : ` : 'You :' } &nbsp;</strong>
      {message.body}
      
    </Typography>
  );


 

  const renderBody = (
      <Stack
        direction={'column'}
        justifyContent={'center'}
        alignItems={'flex-start'}
         sx={{background:'primary.lighter',height:150,boxShadow: '0px -4px 6px rgba(0, 0, 0, 0.1)' ,position:'relative'}}
         >
          <IconButton
          size="small"   
          onClick={onCloseReply}
          sx={{ top: 8,right:8 ,position:'absolute'}} // Position the button to the right
          >
            <Iconify icon={'mingcute:close-fill'}></Iconify>
          </IconButton>
        <Stack direction='row' alignItems={'flex-start'} justifyContent={'space-between'}>
          <Typography variant="caption" sx={{mt:0,ml:2}}>Reply to :</Typography>
          
        </Stack>
        
        <Stack sx={{background:(theme) => alpha(theme.palette.grey[400], 0.18)
                    ,mt:1,mx:4,height:40,width:'90%',
                    borderRadius: 2,
                    boxShadow: '0px 4px 6px rgba(0, 150, 240, 0.2), 0px -4px 6px rgba(0, 150, 240, 0.1), 4px 0px 6px rgba(0, 150, 240, 0.1), -4px 0px 6px rgba(0, 150, 240, 0.1)'
                    }}
                    justifyContent={'flex-start'}
                    alignItems={'center'}
                    direction={'row'}
                    >
                      {renderInfo}
        </Stack>
      </Stack>
  );
  


  

  return (
    
    <>{renderBody}</>
  );
}