import { Avatar, Box, SelectChangeEvent, Stack, Typography, useTheme } from "@mui/material";
import Iconify from "@/shared/components/iconify";
import { alpha } from '@mui/material/styles';
import { useGetContacts, useGetConversation, useGetConversations } from "@/shared/api/chat";
import { useCollapseNav, useMockedUser, useResponsive, useSearchParams } from "@/hooks";
import React, { useCallback, useEffect, useState } from "react";
import { IChatParticipant } from "@/shared/types/chat";



type Props = {
    children:React.ReactNode;
};
export default function ChatSettings({children}:Props){


 ////////////////////////////////
  const {
    collapseDesktop,
    onCloseDesktop,
    onCollapseDesktop,
    //
    openMobile,
    onOpenMobile,
    onCloseMobile,
  } = useCollapseNav();

  const mdUp = useResponsive('up', 'md');

  useEffect(() => {
    if (!mdUp) {
      onCloseMobile();
    }else{
      onCloseDesktop();
      onOpenMobile();
    }
  }, [onCloseDesktop, mdUp]);

  ///////////////////////////////////////

//   const popover = usePopover();

    const [status, setStatus] = useState<'online' | 'alway' | 'busy' | 'offline'>('online');

    const { user1 } = useMockedUser();

    const searchParams = useSearchParams();

    const renderHead = (
        <Stack
        direction="row"
        alignItems="center"
        flexShrink={0}
        sx={{ pl: 2, pb: 1,mt:1}}
        >
            <Box >
                <Avatar
                    src={user1?.photoURL}
                    alt={user1?.displayName}
                    // onClick={popover.onOpen}
                    sx={{ cursor: 'pointer', width: 48, height: 48}}
                    
                >
                    {user1?.displayName?.charAt(0).toUpperCase()}
                </Avatar>
            </Box>
            <Typography variant="subtitle1" sx={{ color: 'text.primary.', ml: 1.5 ,fontSize:15}}>
                {user1.displayName}
            </Typography>
        </Stack>
    );

    const renderSettingsActions = (
        <>
            <Stack
                direction={'row'}
                alignItems="flex-start"
                justifyContent="flex-start"
                sx={{
                    width: 1,
                    height: 1,
                    mt:2,
                    overflow: 'hidden',
                }}
            >
                <Box sx={{width:1}}>
                <Typography sx={{ px:2,py:1,display:'flex',cursor: 'pointer',
                    alignItems:'center',
                    '&:hover': {
                    color: 'primary.main', 
                    backgroundColor:(theme) => alpha(theme.palette.primary.main, 0.1),
                    },}}
                    // onClick={handleNewChannelAction}
                    >
                    <Iconify icon={'uil:channel'} sx={{mr:1}}/>
                    New channel
                </Typography>
                <Typography sx={{ px:2,py:1,display:'flex',cursor: 'pointer',
                    alignItems:'center',
                    '&:hover': {
                    color: 'primary.main', 
                    backgroundColor:(theme) => alpha(theme.palette.primary.main, 0.1),
                    },}} 
                    // onClick={()=>{handleCloseActions()}}
                    >
                    <Iconify icon={'mdi:notification-settings-outline'} sx={{mr:1}}/>
                    Manage notifications
                </Typography>
                <Typography sx={{ px:2,py:1,display:'flex',cursor: 'pointer',
                    alignItems:'center',
                    '&:hover': {
                    color: 'primary.main',
                    backgroundColor:(theme) => alpha(theme.palette.primary.main, 0.1),
                    },}} 
                    // onClick={()=>{handleCloseActions()}}
                    >
                    <Iconify icon={'mdi:anonymous'} sx={{mr:1}}/>
                    Manage anonymity 
                </Typography>
                    
                    <Typography sx={{ px:2,py:1,display:'flex',cursor: 'pointer',
                    alignItems:'center',
                    '&:hover': {
                        color: 'primary.main',
                        backgroundColor:(theme) => alpha(theme.palette.primary.main, 0.1),
                    },}} 
                    // onClick={()=>{handleSettings()}}
                    >
                        <Iconify icon={'circum:settings'} sx={{mr:1}}/>
                        Settings
                    </Typography>
                    </Box>
            </Stack>
        </>
      );

    
    return (
        <>
            <Stack
            sx={{
              width: 1,
              height: 'calc(100vh - 260px)',
              overflow: 'hidden',
              mt:-1,
              
            }}
            
            
          >
            {renderHead}
  
            <Stack
              direction="row"
              sx={{
                width: 1,
                height: 1,
                overflow: 'hidden',
                borderTop: (theme) => `solid 1px ${theme.palette.divider}`,
              }}
            >
              {renderSettingsActions}
  
            </Stack>
            </Stack>

        </>
    );
}