import { useState, useCallback } from "react";

import Button from "@mui/material/Button";
import Avatar from "@mui/material/Avatar";
import Divider from "@mui/material/Divider";
import Tooltip from "@mui/material/Tooltip";
import ListItem from "@mui/material/ListItem";
import MenuItem from "@mui/material/MenuItem";
import ListItemText from "@mui/material/ListItemText";

import Iconify from "@/shared/components/iconify";
import CustomPopover, { usePopover } from "@/shared/components/custom-popover";

import { ITaskShared } from "@/contexts/types/tasks";

// ----------------------------------------------------------------------

type Props = {
  person: ITaskShared;
};

export default function FileManagerInvitedItem({ person }: Props) {
  return (
    <>
      <ListItem
        sx={{
          px: 0,
          py: 1,
        }}
      >
        <Avatar alt={person.name} src={person.avatarUrl} sx={{ mr: 2 }} />

        <ListItemText
          primary={person.name}
          secondary={
            <Tooltip title={person.email}>
              <span>{person.email}</span>
            </Tooltip>
          }
          primaryTypographyProps={{ noWrap: true, typography: "subtitle2" }}
          secondaryTypographyProps={{ noWrap: true, component: "span" }}
          sx={{ flexGrow: 1, pr: 1 }}
        />
      </ListItem>
    </>
  );
}
