import React from 'react';
import { Stack, TextField, MenuItem, Button } from '@mui/material';
import { DatePicker } from '@mui/x-date-pickers/DatePicker';
import { IInvoiceTableFilters, IInvoiceTableFilterValue } from '@/shared/types/invoice';
import Iconify from '@/shared/components/iconify';

interface InvoiceListFiltersProps {
  filters: IInvoiceTableFilters;
  onFilters: (name: string, value: IInvoiceTableFilterValue) => void;
  dateError: boolean;
  paymentModeOptions: string[];
  onResetFilters: VoidFunction; 
}

export default function InvoiceListFilters({
  filters,
  onFilters,
  dateError,
  paymentModeOptions,
  onResetFilters,
}: InvoiceListFiltersProps) {

  
  return (
    <Stack spacing={2} direction={{ xs: 'column', md: 'row' }} sx={{ py: 2.5, px: 3 }}>
      <TextField
        fullWidth
        select
        label="Status"
        value={filters.status}
        onChange={(event) => onFilters('status', event.target.value)}
        SelectProps={{
          MenuProps: {
            PaperProps: { sx: { maxHeight: 220 } },
          },
        }}
        sx={{ maxWidth: { md: 160 } }}
      >
        <MenuItem value="all">All</MenuItem>
        <MenuItem value="paid">Paid</MenuItem>
        <MenuItem value="pending">Pending</MenuItem>
        <MenuItem value="overdue">Overdue</MenuItem>
        <MenuItem value="draft">Draft</MenuItem>
      </TextField>

      <DatePicker
        label="Start date"
        value={filters.startDate}
        onChange={(newValue) => onFilters('startDate', newValue)}
        slotProps={{ textField: { fullWidth: true } }}
        sx={{ maxWidth: { md: 180 } }}
      />

      <DatePicker
        label="End date"
        value={filters.endDate}
        onChange={(newValue) => onFilters('endDate', newValue)}
        slotProps={{
          textField: {
            fullWidth: true,
            error: dateError,
          },
        }}
        sx={{ maxWidth: { md: 180 } }}
      />

      <TextField
        fullWidth
        select
        label="Payment Mode"
        value={filters.paymentMode}
        onChange={(event) => onFilters('paymentMode', event.target.value)}
        SelectProps={{
          multiple: true,
          MenuProps: {
            PaperProps: { sx: { maxHeight: 220 } },
          },
        }}
        sx={{ maxWidth: { md: 160 } }}
      >
        {paymentModeOptions.map((option) => (
          <MenuItem key={option} value={option}>
            {option}
          </MenuItem>
        ))}
      </TextField>
      
    </Stack>
  );
}