import React from 'react';
import {
  Table,
  TableBody,
  TableContainer,
  TableHead,
  TableRow,
  TableCell,
  Checkbox,
} from '@mui/material';
import { IInvoice } from '@/shared/types/invoice';
import Scrollbar from '@/shared/components/scrollbar';
import { TableHeadCustom, TableEmptyRows, TableNoData } from '@/shared/components/table';
import InvoiceTableRow from './invoice-table-row';

const TABLE_HEAD = [
  { id: 'invoiceNumber', label: 'Customer' },
  { id: 'createDate', label: 'Create' },
  { id: 'dueDate', label: 'Due' },
  { id: 'price', label: 'Amount' },
  { id: 'paymentMode', label: 'Payment Mode' },
  { id: 'status', label: 'Status' },
  { id: '' },
];

interface InvoiceListTableProps {
  dataFiltered: IInvoice[];
  dataInPage: IInvoice[];
  table: any; // Replace 'any' with the actual type of your table object
  onDeleteRow: (id: string) => void;
  onEditRow: (id: string) => void;
  onViewRow: (id: string) => void;
}
const emptyRows = (page: number, rowsPerPage: number, totalItems: number) => {
  return page > 0 ? Math.max(0, rowsPerPage - (totalItems % rowsPerPage)) : 0;
};
export default function InvoiceListTable({
  dataFiltered,
  dataInPage,
  table,
  onDeleteRow,
  onEditRow,
  onViewRow,
}: InvoiceListTableProps) {
  return (
    <TableContainer sx={{ position: 'relative', overflow: 'unset' }}>
      <Scrollbar>
        <Table size={table.dense ? 'small' : 'medium'} sx={{ minWidth: 800 }}>
          <TableHeadCustom
            order={table.order}
            orderBy={table.orderBy}
            headLabel={TABLE_HEAD}
            rowCount={dataFiltered.length}
            numSelected={table.selected.length}
            onSort={table.onSort}
            onSelectAllRows={(checked) =>
              table.onSelectAllRows(
                checked,
                dataFiltered.map((row) => row.id)
              )
            }
          />

          <TableBody>
            {dataInPage.map((row) => (
              <InvoiceTableRow
                key={row.id}
                row={row}
                selected={table.selected.includes(row.id)}
                onSelectRow={() => table.onSelectRow(row.id)}
                onViewRow={() => onViewRow(row.id)}
                onEditRow={() => onEditRow(row.id)}
                onDeleteRow={() => onDeleteRow(row.id)}
              />
            ))}

<TableEmptyRows
              height={table.dense ? 56 : 76}
              emptyRows={emptyRows(table.page, table.rowsPerPage, dataFiltered.length)}
            />

            <TableNoData notFound={!dataFiltered.length} />
          </TableBody>
        </Table>
      </Scrollbar>
    </TableContainer>
  );
}