'use client';

import Container from '@mui/material/Container';

import { paths } from '@/routes/paths';

import { useSettingsContext } from '@/shared/components/settings';
import CustomBreadcrumbs from '@/shared/components/custom-breadcrumbs';

import InvoiceNewAddForm from '../invoice-new-add-form';
import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
import { AdapterDateFns } from '@mui/x-date-pickers/AdapterDateFns';
import InvoiceLayout from './invoice-layout';

// ----------------------------------------------------------------------

export default function InvoiceCreateView() {
  const settings = useSettingsContext();

  return (
    <InvoiceLayout>
    <LocalizationProvider dateAdapter={AdapterDateFns}>
      <Container maxWidth={settings.themeStretch ? false : 'lg'}>
        <CustomBreadcrumbs
          heading="Create a new invoice"
          links={[
            {
              name: 'Dashboard',
              href: paths.dashboard.root,
            },
            {
              name: 'Invoice',
              href: paths.dashboard.invoice.root,
            },
            {
              name: 'New Invoice',
            },
          ]}
          sx={{
            mb: { xs: 3, md: 5 },
          }}
        />

        <InvoiceNewAddForm />
      </Container>
    </LocalizationProvider>  
    </InvoiceLayout>
  );
}
